@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.BusinessCaseOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.SettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.SettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Business case resource.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### BusinessCaseOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var businessCaseOperation = new AzureNative.Migrate.BusinessCaseOperation("businessCaseOperation", new()
 *     {
 *         BusinessCaseName = "sample-business-case",
 *         ProjectName = "multipleto8617project",
 *         ResourceGroupName = "rgopenapi",
 *         Settings = new AzureNative.Migrate.Inputs.SettingsArgs
 *         {
 *             AzureSettings = new AzureNative.Migrate.Inputs.AzureSettingsArgs
 *             {
 *                 AvsLaborCostPercentage = 0,
 *                 BusinessCaseType = AzureNative.Migrate.MigrationStrategy.OptimizeForCost,
 *                 ComfortFactor = 29,
 *                 Currency = AzureNative.Migrate.BusinessCaseCurrency.USD,
 *                 DiscountPercentage = 83,
 *                 IaasLaborCostPercentage = 94,
 *                 InfrastructureGrowthRate = 83,
 *                 NetworkCostPercentage = 40,
 *                 PaasLaborCostPercentage = 47,
 *                 PerYearMigrationCompletionPercentage =
 *                 {
 *                     { "Year0", 20 },
 *                     { "Year1", 30 },
 *                     { "Year2", 60 },
 *                     { "Year3", 90 },
 *                 },
 *                 PerformanceDataEndTime = "2023-11-08T07:10:07.764Z",
 *                 PerformanceDataStartTime = "2023-11-08T07:10:07.764Z",
 *                 PerformanceUtilizationPercentile = 4,
 *                 SavingsOption = AzureNative.Migrate.SavingsOption.RI3Year,
 *                 TargetLocation = "WestUs2",
 *                 Wacc = 79,
 *                 WorkloadDiscoverySource = AzureNative.Migrate.DiscoverySource.Appliance,
 *             },
 *             OnPremiseSettings = new AzureNative.Migrate.Inputs.OnPremiseSettingsArgs
 *             {
 *                 ComputeSettings = new AzureNative.Migrate.Inputs.ComputeSettingsArgs
 *                 {
 *                     HyperthreadCoreToMemoryRatio = 12,
 *                     Price = 16,
 *                     RhelLinuxServerLicensing = new AzureNative.Migrate.Inputs.LinuxServerLicensingSettingsArgs
 *                     {
 *                         LicenseCost = 9,
 *                     },
 *                     SqlServerLicensing = new[]
 *                     {
 *                         new AzureNative.Migrate.Inputs.SqlServerLicensingSettingsArgs
 *                         {
 *                             LicenseCost = 27,
 *                             SoftwareAssuranceCost = 16,
 *                             Version = AzureNative.Migrate.SqlServerLicenseType.Enterprise,
 *                         },
 *                     },
 *                     SuseLinuxServerLicensing = new AzureNative.Migrate.Inputs.LinuxServerLicensingSettingsArgs
 *                     {
 *                         LicenseCost = 9,
 *                     },
 *                     VirtualizationSoftwareSettings = new AzureNative.Migrate.Inputs.VirtualizationSoftwareSettingsArgs
 *                     {
 *                         LicenseAndSupportList = new[]
 *                         {
 *                             new AzureNative.Migrate.Inputs.VsphereLicenseArgs
 *                             {
 *                                 BasicSupportCost = 22,
 *                                 LicenseCost = 8,
 *                                 LicenseType = AzureNative.Migrate.LicenseType.VSphereStandard,
 *                                 ProductionSupportCost = 22,
 *                             },
 *                         },
 *                         NumberOfPhysicalCoresPerLicense = 17,
 *                         SoftwareAssuranceCost = 14,
 *                     },
 *                     WindowsServerLicensing = new AzureNative.Migrate.Inputs.WindowsServerLicensingSettingsArgs
 *                     {
 *                         LicenseCost = 9,
 *                         LicensesPerCore = 11,
 *                         SoftwareAssuranceCost = 1,
 *                     },
 *                 },
 *                 FacilitySettings = new AzureNative.Migrate.Inputs.FacilitySettingsArgs
 *                 {
 *                     FacilitiesCost = 7,
 *                 },
 *                 LaborSettings = new AzureNative.Migrate.Inputs.LaborSettingsArgs
 *                 {
 *                     HourlyAdminCost = 25,
 *                     PhysicalServersPerAdmin = 6,
 *                     VirtualMachinesPerAdmin = 24,
 *                 },
 *                 ManagementSettings = new AzureNative.Migrate.Inputs.ManagementSettingsArgs
 *                 {
 *                     HypervVirtualizationManagementSettings = new AzureNative.Migrate.Inputs.HypervVirtualizationManagementSettingsArgs
 *                     {
 *                         LicenseAndSupportList = new[]
 *                         {
 *                             new AzureNative.Migrate.Inputs.HypervLicenseArgs
 *                             {
 *                                 LicenseCost = 4,
 *                                 LicenseType = AzureNative.Migrate.HyperVLicenseType.Standard,
 *                             },
 *                         },
 *                         NumberOfPhysicalCoresPerLicense = 2,
 *                         SoftwareAssuranceCost = 11,
 *                     },
 *                     OtherManagementCostsSettings = new AzureNative.Migrate.Inputs.OtherManagementCostsSettingsArgs
 *                     {
 *                         DataProtectionCostPerServerPerYear = 18,
 *                         MonitoringCostPerServerPerYear = 10,
 *                         PatchingCostPerServerPerYear = 18,
 *                     },
 *                     ThirdPartyManagementSettings = new AzureNative.Migrate.Inputs.ThirdPartyManagementSettingsArgs
 *                     {
 *                         LicenseCost = 23,
 *                         SupportCost = 9,
 *                     },
 *                     VsphereManagementSettings = new AzureNative.Migrate.Inputs.VsphereManagementSettingsArgs
 *                     {
 *                         LicenseAndSupportList = new[]
 *                         {
 *                             new AzureNative.Migrate.Inputs.VsphereManagementLicenseArgs
 *                             {
 *                                 BasicSupportCost = 1,
 *                                 LicenseCost = 6,
 *                                 LicenseType = AzureNative.Migrate.VsphereManagementLicenseType.VSphereServerStandard,
 *                                 ProductionSupportCost = 18,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 NetworkSettings = new AzureNative.Migrate.Inputs.NetworkSettingsArgs
 *                 {
 *                     HardwareSoftwareCostPercentage = 50,
 *                     MaintenanceCostPercentage = 48,
 *                 },
 *                 SecuritySettings = new AzureNative.Migrate.Inputs.SecuritySettingsArgs
 *                 {
 *                     ServerSecurityCostPerServerPerYear = 14,
 *                     SqlServerSecurityCostPerServerPerYear = 7,
 *                 },
 *                 StorageSettings = new AzureNative.Migrate.Inputs.StorageSettingsArgs
 *                 {
 *                     CostPerGbPerMonth = 22,
 *                     MaintainanceCostPercentageToAcquisitionCost = 1,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewBusinessCaseOperation(ctx, "businessCaseOperation", &migrate.BusinessCaseOperationArgs{
 * 			BusinessCaseName:  pulumi.String("sample-business-case"),
 * 			ProjectName:       pulumi.String("multipleto8617project"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Settings: &migrate.SettingsArgs{
 * 				AzureSettings: &migrate.AzureSettingsArgs{
 * 					AvsLaborCostPercentage:   pulumi.Float64(0),
 * 					BusinessCaseType:         pulumi.String(migrate.MigrationStrategyOptimizeForCost),
 * 					ComfortFactor:            pulumi.Float64(29),
 * 					Currency:                 pulumi.String(migrate.BusinessCaseCurrencyUSD),
 * 					DiscountPercentage:       pulumi.Float64(83),
 * 					IaasLaborCostPercentage:  pulumi.Float64(94),
 * 					InfrastructureGrowthRate: pulumi.Float64(83),
 * 					NetworkCostPercentage:    pulumi.Float64(40),
 * 					PaasLaborCostPercentage:  pulumi.Float64(47),
 * 					PerYearMigrationCompletionPercentage: pulumi.Float64Map{
 * 						"Year0": pulumi.Float64(20),
 * 						"Year1": pulumi.Float64(30),
 * 						"Year2": pulumi.Float64(60),
 * 						"Year3": pulumi.Float64(90),
 * 					},
 * 					PerformanceDataEndTime:           pulumi.String("2023-11-08T07:10:07.764Z"),
 * 					PerformanceDataStartTime:         pulumi.String("2023-11-08T07:10:07.764Z"),
 * 					PerformanceUtilizationPercentile: pulumi.Float64(4),
 * 					SavingsOption:                    pulumi.String(migrate.SavingsOptionRI3Year),
 * 					TargetLocation:                   pulumi.String("WestUs2"),
 * 					Wacc:                             pulumi.Float64(79),
 * 					WorkloadDiscoverySource:          pulumi.String(migrate.DiscoverySourceAppliance),
 * 				},
 * 				OnPremiseSettings: &migrate.OnPremiseSettingsArgs{
 * 					ComputeSettings: &migrate.ComputeSettingsArgs{
 * 						HyperthreadCoreToMemoryRatio: pulumi.Float64(12),
 * 						Price:                        pulumi.Float64(16),
 * 						RhelLinuxServerLicensing: &migrate.LinuxServerLicensingSettingsArgs{
 * 							LicenseCost: pulumi.Float64(9),
 * 						},
 * 						SqlServerLicensing: migrate.SqlServerLicensingSettingsArray{
 * 							&migrate.SqlServerLicensingSettingsArgs{
 * 								LicenseCost:           pulumi.Float64(27),
 * 								SoftwareAssuranceCost: pulumi.Float64(16),
 * 								Version:               pulumi.String(migrate.SqlServerLicenseTypeEnterprise),
 * 							},
 * 						},
 * 						SuseLinuxServerLicensing: &migrate.LinuxServerLicensingSettingsArgs{
 * 							LicenseCost: pulumi.Float64(9),
 * 						},
 * 						VirtualizationSoftwareSettings: &migrate.VirtualizationSoftwareSettingsArgs{
 * 							LicenseAndSupportList: migrate.VsphereLicenseArray{
 * 								&migrate.VsphereLicenseArgs{
 * 									BasicSupportCost:      pulumi.Float64(22),
 * 									LicenseCost:           pulumi.Float64(8),
 * 									LicenseType:           pulumi.String(migrate.LicenseTypeVSphereStandard),
 * 									ProductionSupportCost: pulumi.Float64(22),
 * 								},
 * 							},
 * 							NumberOfPhysicalCoresPerLicense: pulumi.Int(17),
 * 							SoftwareAssuranceCost:           pulumi.Float64(14),
 * 						},
 * 						WindowsServerLicensing: &migrate.WindowsServerLicensingSettingsArgs{
 * 							LicenseCost:           pulumi.Float64(9),
 * 							LicensesPerCore:       pulumi.Int(11),
 * 							SoftwareAssuranceCost: pulumi.Float64(1),
 * 						},
 * 					},
 * 					FacilitySettings: &migrate.FacilitySettingsArgs{
 * 						FacilitiesCost: pulumi.Float64(7),
 * 					},
 * 					LaborSettings: &migrate.LaborSettingsArgs{
 * 						HourlyAdminCost:         pulumi.Float64(25),
 * 						PhysicalServersPerAdmin: pulumi.Int(6),
 * 						VirtualMachinesPerAdmin: pulumi.Int(24),
 * 					},
 * 					ManagementSettings: &migrate.ManagementSettingsArgs{
 * 						HypervVirtualizationManagementSettings: &migrate.HypervVirtualizationManagementSettingsArgs{
 * 							LicenseAndSupportList: migrate.HypervLicenseArray{
 * 								&migrate.HypervLicenseArgs{
 * 									LicenseCost: pulumi.Float64(4),
 * 									LicenseType: pulumi.String(migrate.HyperVLicenseTypeStandard),
 * 								},
 * 							},
 * 							NumberOfPhysicalCoresPerLicense: pulumi.Int(2),
 * 							SoftwareAssuranceCost:           pulumi.Float64(11),
 * 						},
 * 						OtherManagementCostsSettings: &migrate.OtherManagementCostsSettingsArgs{
 * 							DataProtectionCostPerServerPerYear: pulumi.Float64(18),
 * 							MonitoringCostPerServerPerYear:     pulumi.Float64(10),
 * 							PatchingCostPerServerPerYear:       pulumi.Float64(18),
 * 						},
 * 						ThirdPartyManagementSettings: &migrate.ThirdPartyManagementSettingsArgs{
 * 							LicenseCost: pulumi.Float64(23),
 * 							SupportCost: pulumi.Float64(9),
 * 						},
 * 						VsphereManagementSettings: &migrate.VsphereManagementSettingsArgs{
 * 							LicenseAndSupportList: migrate.VsphereManagementLicenseArray{
 * 								&migrate.VsphereManagementLicenseArgs{
 * 									BasicSupportCost:      pulumi.Float64(1),
 * 									LicenseCost:           pulumi.Float64(6),
 * 									LicenseType:           pulumi.String(migrate.VsphereManagementLicenseTypeVSphereServerStandard),
 * 									ProductionSupportCost: pulumi.Float64(18),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					NetworkSettings: &migrate.NetworkSettingsArgs{
 * 						HardwareSoftwareCostPercentage: pulumi.Float64(50),
 * 						MaintenanceCostPercentage:      pulumi.Float64(48),
 * 					},
 * 					SecuritySettings: &migrate.SecuritySettingsArgs{
 * 						ServerSecurityCostPerServerPerYear:    pulumi.Float64(14),
 * 						SqlServerSecurityCostPerServerPerYear: pulumi.Float64(7),
 * 					},
 * 					StorageSettings: &migrate.StorageSettingsArgs{
 * 						CostPerGbPerMonth: pulumi.Float64(22),
 * 						MaintainanceCostPercentageToAcquisitionCost: pulumi.Float64(1),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.BusinessCaseOperation;
 * import com.pulumi.azurenative.migrate.BusinessCaseOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.SettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.AzureSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.OnPremiseSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.LinuxServerLicensingSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.VirtualizationSoftwareSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.WindowsServerLicensingSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.FacilitySettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.LaborSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.ManagementSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.HypervVirtualizationManagementSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.OtherManagementCostsSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.ThirdPartyManagementSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.VsphereManagementSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.NetworkSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.SecuritySettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.StorageSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var businessCaseOperation = new BusinessCaseOperation("businessCaseOperation", BusinessCaseOperationArgs.builder()
 *             .businessCaseName("sample-business-case")
 *             .projectName("multipleto8617project")
 *             .resourceGroupName("rgopenapi")
 *             .settings(SettingsArgs.builder()
 *                 .azureSettings(AzureSettingsArgs.builder()
 *                     .avsLaborCostPercentage(0)
 *                     .businessCaseType("OptimizeForCost")
 *                     .comfortFactor(29)
 *                     .currency("USD")
 *                     .discountPercentage(83)
 *                     .iaasLaborCostPercentage(94)
 *                     .infrastructureGrowthRate(83)
 *                     .networkCostPercentage(40)
 *                     .paasLaborCostPercentage(47)
 *                     .perYearMigrationCompletionPercentage(Map.ofEntries(
 *                         Map.entry("Year0", 20),
 *                         Map.entry("Year1", 30),
 *                         Map.entry("Year2", 60),
 *                         Map.entry("Year3", 90)
 *                     ))
 *                     .performanceDataEndTime("2023-11-08T07:10:07.764Z")
 *                     .performanceDataStartTime("2023-11-08T07:10:07.764Z")
 *                     .performanceUtilizationPercentile(4)
 *                     .savingsOption("RI3Year")
 *                     .targetLocation("WestUs2")
 *                     .wacc(79)
 *                     .workloadDiscoverySource("Appliance")
 *                     .build())
 *                 .onPremiseSettings(OnPremiseSettingsArgs.builder()
 *                     .computeSettings(ComputeSettingsArgs.builder()
 *                         .hyperthreadCoreToMemoryRatio(12)
 *                         .price(16)
 *                         .rhelLinuxServerLicensing(LinuxServerLicensingSettingsArgs.builder()
 *                             .licenseCost(9)
 *                             .build())
 *                         .sqlServerLicensing(SqlServerLicensingSettingsArgs.builder()
 *                             .licenseCost(27)
 *                             .softwareAssuranceCost(16)
 *                             .version("Enterprise")
 *                             .build())
 *                         .suseLinuxServerLicensing(LinuxServerLicensingSettingsArgs.builder()
 *                             .licenseCost(9)
 *                             .build())
 *                         .virtualizationSoftwareSettings(VirtualizationSoftwareSettingsArgs.builder()
 *                             .licenseAndSupportList(VsphereLicenseArgs.builder()
 *                                 .basicSupportCost(22)
 *                                 .licenseCost(8)
 *                                 .licenseType("VSphereStandard")
 *                                 .productionSupportCost(22)
 *                                 .build())
 *                             .numberOfPhysicalCoresPerLicense(17)
 *                             .softwareAssuranceCost(14)
 *                             .build())
 *                         .windowsServerLicensing(WindowsServerLicensingSettingsArgs.builder()
 *                             .licenseCost(9)
 *                             .licensesPerCore(11)
 *                             .softwareAssuranceCost(1)
 *                             .build())
 *                         .build())
 *                     .facilitySettings(FacilitySettingsArgs.builder()
 *                         .facilitiesCost(7)
 *                         .build())
 *                     .laborSettings(LaborSettingsArgs.builder()
 *                         .hourlyAdminCost(25)
 *                         .physicalServersPerAdmin(6)
 *                         .virtualMachinesPerAdmin(24)
 *                         .build())
 *                     .managementSettings(ManagementSettingsArgs.builder()
 *                         .hypervVirtualizationManagementSettings(HypervVirtualizationManagementSettingsArgs.builder()
 *                             .licenseAndSupportList(HypervLicenseArgs.builder()
 *                                 .licenseCost(4)
 *                                 .licenseType("Standard")
 *                                 .build())
 *                             .numberOfPhysicalCoresPerLicense(2)
 *                             .softwareAssuranceCost(11)
 *                             .build())
 *                         .otherManagementCostsSettings(OtherManagementCostsSettingsArgs.builder()
 *                             .dataProtectionCostPerServerPerYear(18)
 *                             .monitoringCostPerServerPerYear(10)
 *                             .patchingCostPerServerPerYear(18)
 *                             .build())
 *                         .thirdPartyManagementSettings(ThirdPartyManagementSettingsArgs.builder()
 *                             .licenseCost(23)
 *                             .supportCost(9)
 *                             .build())
 *                         .vsphereManagementSettings(VsphereManagementSettingsArgs.builder()
 *                             .licenseAndSupportList(VsphereManagementLicenseArgs.builder()
 *                                 .basicSupportCost(1)
 *                                 .licenseCost(6)
 *                                 .licenseType("VSphereServerStandard")
 *                                 .productionSupportCost(18)
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .networkSettings(NetworkSettingsArgs.builder()
 *                         .hardwareSoftwareCostPercentage(50)
 *                         .maintenanceCostPercentage(48)
 *                         .build())
 *                     .securitySettings(SecuritySettingsArgs.builder()
 *                         .serverSecurityCostPerServerPerYear(14)
 *                         .sqlServerSecurityCostPerServerPerYear(7)
 *                         .build())
 *                     .storageSettings(StorageSettingsArgs.builder()
 *                         .costPerGbPerMonth(22)
 *                         .maintainanceCostPercentageToAcquisitionCost(1)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:BusinessCaseOperation sample-business-case /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/businessCases/{businessCaseName}
 * ```
 * @property businessCaseName Business case ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settings Business case settings.
 */
public data class BusinessCaseOperationArgs(
    public val businessCaseName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settings: Output<SettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.BusinessCaseOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.BusinessCaseOperationArgs =
        com.pulumi.azurenative.migrate.BusinessCaseOperationArgs.builder()
            .businessCaseName(businessCaseName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BusinessCaseOperationArgs].
 */
@PulumiTagMarker
public class BusinessCaseOperationArgsBuilder internal constructor() {
    private var businessCaseName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settings: Output<SettingsArgs>? = null

    /**
     * @param value Business case ARM name
     */
    @JvmName("oemouhqbijycpqod")
    public suspend fun businessCaseName(`value`: Output<String>) {
        this.businessCaseName = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("mixfmccqpktrceme")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gsspdijetgienhou")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Business case settings.
     */
    @JvmName("sgimaeocvokffbee")
    public suspend fun settings(`value`: Output<SettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value Business case ARM name
     */
    @JvmName("oigybvlilghytkbq")
    public suspend fun businessCaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessCaseName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("cjotpmxxtibocxdu")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hrhppmnntnyjgdon")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Business case settings.
     */
    @JvmName("fkcllphnlueqjumu")
    public suspend fun settings(`value`: SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Business case settings.
     */
    @JvmName("nqsrgjqwsdhlgfki")
    public suspend fun settings(argument: suspend SettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): BusinessCaseOperationArgs = BusinessCaseOperationArgs(
        businessCaseName = businessCaseName,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        settings = settings,
    )
}
