@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.HyperVCollectorArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### HyperVCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hyperVCollector = new AzureNative.Migrate.HyperVCollector("hyperVCollector", new()
 *     {
 *         ETag = "\"00000981-0000-0300-0000-5d74cd5f0000\"",
 *         HyperVCollectorName = "migrateprojectce73collector",
 *         ProjectName = "migrateprojectce73project",
 *         Properties = new AzureNative.Migrate.Inputs.CollectorPropertiesArgs
 *         {
 *             AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesArgs
 *             {
 *                 SpnDetails = new AzureNative.Migrate.Inputs.CollectorBodyAgentSpnPropertiesArgs
 *                 {
 *                     ApplicationId = "827f1053-44dc-439f-b832-05416dcce12b",
 *                     Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/migrateprojectce73agentauthaadapp",
 *                     Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                     ObjectId = "be75098e-c0fc-4ac4-98c7-282ebbcf8370",
 *                     TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 },
 *             },
 *             DiscoverySiteId = "/subscriptions/8c3c936a-c09b-4de3-830b-3f5f244d72e9/resourceGroups/ContosoITHyperV/providers/Microsoft.OffAzure/HyperVSites/migrateprojectce73site",
 *         },
 *         ResourceGroupName = "contosoithyperv",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewHyperVCollector(ctx, "hyperVCollector", &migrate.HyperVCollectorArgs{
 * 			ETag:                pulumi.String("\"00000981-0000-0300-0000-5d74cd5f0000\""),
 * 			HyperVCollectorName: pulumi.String("migrateprojectce73collector"),
 * 			ProjectName:         pulumi.String("migrateprojectce73project"),
 * 			Properties: &migrate.CollectorPropertiesArgs{
 * 				AgentProperties: &migrate.CollectorAgentPropertiesArgs{
 * 					SpnDetails: &migrate.CollectorBodyAgentSpnPropertiesArgs{
 * 						ApplicationId: pulumi.String("827f1053-44dc-439f-b832-05416dcce12b"),
 * 						Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/migrateprojectce73agentauthaadapp"),
 * 						Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 						ObjectId:      pulumi.String("be75098e-c0fc-4ac4-98c7-282ebbcf8370"),
 * 						TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					},
 * 				},
 * 				DiscoverySiteId: pulumi.String("/subscriptions/8c3c936a-c09b-4de3-830b-3f5f244d72e9/resourceGroups/ContosoITHyperV/providers/Microsoft.OffAzure/HyperVSites/migrateprojectce73site"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosoithyperv"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.HyperVCollector;
 * import com.pulumi.azurenative.migrate.HyperVCollectorArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hyperVCollector = new HyperVCollector("hyperVCollector", HyperVCollectorArgs.builder()
 *             .eTag("\"00000981-0000-0300-0000-5d74cd5f0000\"")
 *             .hyperVCollectorName("migrateprojectce73collector")
 *             .projectName("migrateprojectce73project")
 *             .properties(CollectorPropertiesArgs.builder()
 *                 .agentProperties(CollectorAgentPropertiesArgs.builder()
 *                     .spnDetails(CollectorBodyAgentSpnPropertiesArgs.builder()
 *                         .applicationId("827f1053-44dc-439f-b832-05416dcce12b")
 *                         .audience("https://72f988bf-86f1-41af-91ab-2d7cd011db47/migrateprojectce73agentauthaadapp")
 *                         .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                         .objectId("be75098e-c0fc-4ac4-98c7-282ebbcf8370")
 *                         .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                         .build())
 *                     .build())
 *                 .discoverySiteId("/subscriptions/8c3c936a-c09b-4de3-830b-3f5f244d72e9/resourceGroups/ContosoITHyperV/providers/Microsoft.OffAzure/HyperVSites/migrateprojectce73site")
 *                 .build())
 *             .resourceGroupName("contosoithyperv")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:HyperVCollector migrateprojectce73collector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/hypervcollectors/{hyperVCollectorName}
 * ```
 * @property eTag
 * @property hyperVCollectorName Unique name of a Hyper-V collector within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property properties
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class HyperVCollectorArgs(
    public val eTag: Output<String>? = null,
    public val hyperVCollectorName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<CollectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.HyperVCollectorArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.HyperVCollectorArgs =
        com.pulumi.azurenative.migrate.HyperVCollectorArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .hyperVCollectorName(hyperVCollectorName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVCollectorArgs].
 */
@PulumiTagMarker
public class HyperVCollectorArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var hyperVCollectorName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<CollectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("txgptoueudajkkid")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Unique name of a Hyper-V collector within a project.
     */
    @JvmName("bhjbyfhwsdyfxsgi")
    public suspend fun hyperVCollectorName(`value`: Output<String>) {
        this.hyperVCollectorName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("dvgohryuwtnjywxa")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value
     */
    @JvmName("athccccjtwgneqek")
    public suspend fun properties(`value`: Output<CollectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("vumwitqgccullpwg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("urneqfdymdyfpwmj")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Unique name of a Hyper-V collector within a project.
     */
    @JvmName("jtjhvumghqanioxd")
    public suspend fun hyperVCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVCollectorName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("fnjxoyqbxuthlgbj")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value
     */
    @JvmName("gtooshwerqnrqlbn")
    public suspend fun properties(`value`: CollectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bwkqlkwcrdbiwxve")
    public suspend fun properties(argument: suspend CollectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("rgiktwcolvvsnhld")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): HyperVCollectorArgs = HyperVCollectorArgs(
        eTag = eTag,
        hyperVCollectorName = hyperVCollectorName,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
