@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.HypervCollectorsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Hyper-V collector resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### HypervCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervCollectorsOperation = new AzureNative.Migrate.HypervCollectorsOperation("hypervCollectorsOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "12f1d90f-b3fa-4926-8893-e56803a09af0",
 *             LastHeartbeatUtc = "2022-07-07T14:25:35.708325Z",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "e3bd6eaa-980b-40ae-a30e-2a5069ba097c",
 *                 Audience = "e3bd6eaa-980b-40ae-a30e-2a5069ba097c",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "01b9f9e2-2d82-414c-adaa-09ce259b6b44",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *             Version = "2.0.1993.19",
 *         },
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/HyperVSites/test-60527site",
 *         HypervCollectorName = "test-697cecollector",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ResourceGroupName = "ayagrawRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewHypervCollectorsOperation(ctx, "hypervCollectorsOperation", &migrate.HypervCollectorsOperationArgs{
 * 			AgentProperties: &migrate.CollectorAgentPropertiesBaseArgs{
 * 				Id:               pulumi.String("12f1d90f-b3fa-4926-8893-e56803a09af0"),
 * 				LastHeartbeatUtc: pulumi.String("2022-07-07T14:25:35.708325Z"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("e3bd6eaa-980b-40ae-a30e-2a5069ba097c"),
 * 					Audience:      pulumi.String("e3bd6eaa-980b-40ae-a30e-2a5069ba097c"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("01b9f9e2-2d82-414c-adaa-09ce259b6b44"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 				Version: pulumi.String("2.0.1993.19"),
 * 			},
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/HyperVSites/test-60527site"),
 * 			HypervCollectorName: pulumi.String("test-697cecollector"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.HypervCollectorsOperation;
 * import com.pulumi.azurenative.migrate.HypervCollectorsOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervCollectorsOperation = new HypervCollectorsOperation("hypervCollectorsOperation", HypervCollectorsOperationArgs.builder()
 *             .agentProperties(CollectorAgentPropertiesBaseArgs.builder()
 *                 .id("12f1d90f-b3fa-4926-8893-e56803a09af0")
 *                 .lastHeartbeatUtc("2022-07-07T14:25:35.708325Z")
 *                 .spnDetails(CollectorAgentSpnPropertiesBaseArgs.builder()
 *                     .applicationId("e3bd6eaa-980b-40ae-a30e-2a5069ba097c")
 *                     .audience("e3bd6eaa-980b-40ae-a30e-2a5069ba097c")
 *                     .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .objectId("01b9f9e2-2d82-414c-adaa-09ce259b6b44")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .version("2.0.1993.19")
 *                 .build())
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/HyperVSites/test-60527site")
 *             .hypervCollectorName("test-697cecollector")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:HypervCollectorsOperation test-697cecollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/hypervcollectors/{hypervCollectorName}
 * ```
 * @property agentProperties Gets or sets the collector agent properties.
 * @property discoverySiteId Gets the discovery site id.
 * @property hypervCollectorName Hyper-V collector ARM name
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class HypervCollectorsOperationArgs(
    public val agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val hypervCollectorName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.HypervCollectorsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.HypervCollectorsOperationArgs =
        com.pulumi.azurenative.migrate.HypervCollectorsOperationArgs.builder()
            .agentProperties(agentProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .hypervCollectorName(hypervCollectorName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HypervCollectorsOperationArgs].
 */
@PulumiTagMarker
public class HypervCollectorsOperationArgsBuilder internal constructor() {
    private var agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null

    private var discoverySiteId: Output<String>? = null

    private var hypervCollectorName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("fwpfppqihnrobbwj")
    public suspend fun agentProperties(`value`: Output<CollectorAgentPropertiesBaseArgs>) {
        this.agentProperties = value
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("dtvqmxdmesxsixuq")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value Hyper-V collector ARM name
     */
    @JvmName("fhuockffafsdmlmi")
    public suspend fun hypervCollectorName(`value`: Output<String>) {
        this.hypervCollectorName = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ysgiebxqeqcxwqcw")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("aapdgdgbyxddpmsj")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvoccelcquwbvgko")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("caufbfjrhxjjyswt")
    public suspend fun agentProperties(`value`: CollectorAgentPropertiesBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProperties = mapped
    }

    /**
     * @param argument Gets or sets the collector agent properties.
     */
    @JvmName("msbongdqaqilkuet")
    public suspend fun agentProperties(argument: suspend CollectorAgentPropertiesBaseArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentPropertiesBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentProperties = mapped
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("fuhxvtnkckscpoen")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value Hyper-V collector ARM name
     */
    @JvmName("awcibxwmcgfyfevc")
    public suspend fun hypervCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hypervCollectorName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("sisjhkydmclnljii")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ohiabiysssacpqvl")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("qdmkpvpovkomdkti")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mrdqmhvnjxpdfoom")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pgfdorboatjfqocl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): HypervCollectorsOperationArgs = HypervCollectorsOperationArgs(
        agentProperties = agentProperties,
        discoverySiteId = discoverySiteId,
        hypervCollectorName = hypervCollectorName,
        projectName = projectName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
