@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.ImportCollectorPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.ImportCollectorPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ImportCollector].
 */
@PulumiTagMarker
public class ImportCollectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImportCollectorArgs = ImportCollectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImportCollectorArgsBuilder.() -> Unit) {
        val builder = ImportCollectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImportCollector {
        val builtJavaResource = com.pulumi.azurenative.migrate.ImportCollector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImportCollector(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### ImportCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importCollector = new AzureNative.Migrate.ImportCollector("importCollector", new()
 *     {
 *         ImportCollectorName = "importCollector2952",
 *         ProjectName = "rajoshCCY9671project",
 *         ResourceGroupName = "markusavstestrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewImportCollector(ctx, "importCollector", &migrate.ImportCollectorArgs{
 * 			ImportCollectorName: pulumi.String("importCollector2952"),
 * 			ProjectName:         pulumi.String("rajoshCCY9671project"),
 * 			ResourceGroupName:   pulumi.String("markusavstestrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ImportCollector;
 * import com.pulumi.azurenative.migrate.ImportCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importCollector = new ImportCollector("importCollector", ImportCollectorArgs.builder()
 *             .importCollectorName("importCollector2952")
 *             .projectName("rajoshCCY9671project")
 *             .resourceGroupName("markusavstestrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ImportCollector importCollector2952 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/importcollectors/{importCollectorName}
 * ```
 */
public class ImportCollector internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.ImportCollector,
) : KotlinCustomResource(javaResource, ImportCollectorMapper) {
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ImportCollectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ImportCollectorMapper : ResourceMapper<ImportCollector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.ImportCollector::class == javaResource::class

    override fun map(javaResource: Resource): ImportCollector = ImportCollector(
        javaResource as
            com.pulumi.azurenative.migrate.ImportCollector,
    )
}

/**
 * @see [ImportCollector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImportCollector].
 */
public suspend fun importCollector(
    name: String,
    block: suspend ImportCollectorResourceBuilder.() -> Unit,
): ImportCollector {
    val builder = ImportCollectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImportCollector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun importCollector(name: String): ImportCollector {
    val builder = ImportCollectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
