@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateAgentModelPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateAgentModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateAgentModelPropertiesResponse.Companion.toKotlin as migrateAgentModelPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateAgentModelResponseSystemData.Companion.toKotlin as migrateAgentModelResponseSystemDataToKotlin

/**
 * Builder for [MigrateAgent].
 */
@PulumiTagMarker
public class MigrateAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrateAgentArgs = MigrateAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MigrateAgentArgsBuilder.() -> Unit) {
        val builder = MigrateAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MigrateAgent {
        val builtJavaResource = com.pulumi.azurenative.migrate.MigrateAgent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MigrateAgent(builtJavaResource)
    }
}

/**
 * MigrateAgent model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### MigrateAgent_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateAgent = new AzureNative.Migrate.MigrateAgent("migrateAgent", new()
 *     {
 *         AgentName = "l",
 *         ModernizeProjectName = "rq1yec",
 *         Properties = new AzureNative.Migrate.Inputs.MigrateAgentModelPropertiesArgs
 *         {
 *             AuthenticationIdentity = new AzureNative.Migrate.Inputs.IdentityModelArgs
 *             {
 *                 AadAuthority = "isbicanvfefdaci",
 *                 ApplicationId = "dibfqwjrnzikktkwe",
 *                 Audience = "yrfxszjhkczoyfi",
 *                 ObjectId = "xfhhdosr",
 *                 TenantId = "uwceuawplakwjswbvllffbsz",
 *             },
 *             CustomProperties = null,
 *             MachineId = "sihoniqzqfz",
 *             MachineName = "glhejppirkiamgxxro",
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key5560", "jgffrfcgjrm" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateAgent(ctx, "migrateAgent", &migrate.MigrateAgentArgs{
 * 			AgentName:            pulumi.String("l"),
 * 			ModernizeProjectName: pulumi.String("rq1yec"),
 * 			Properties: &migrate.MigrateAgentModelPropertiesArgs{
 * 				AuthenticationIdentity: &migrate.IdentityModelArgs{
 * 					AadAuthority:  pulumi.String("isbicanvfefdaci"),
 * 					ApplicationId: pulumi.String("dibfqwjrnzikktkwe"),
 * 					Audience:      pulumi.String("yrfxszjhkczoyfi"),
 * 					ObjectId:      pulumi.String("xfhhdosr"),
 * 					TenantId:      pulumi.String("uwceuawplakwjswbvllffbsz"),
 * 				},
 * 				CustomProperties: nil,
 * 				MachineId:        pulumi.String("sihoniqzqfz"),
 * 				MachineName:      pulumi.String("glhejppirkiamgxxro"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * 			Tags: pulumi.StringMap{
 * 				"key5560": pulumi.String("jgffrfcgjrm"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateAgent;
 * import com.pulumi.azurenative.migrate.MigrateAgentArgs;
 * import com.pulumi.azurenative.migrate.inputs.MigrateAgentModelPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.IdentityModelArgs;
 * import com.pulumi.azurenative.migrate.inputs.VMwareMigrateAgentModelCustomPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateAgent = new MigrateAgent("migrateAgent", MigrateAgentArgs.builder()
 *             .agentName("l")
 *             .modernizeProjectName("rq1yec")
 *             .properties(MigrateAgentModelPropertiesArgs.builder()
 *                 .authenticationIdentity(IdentityModelArgs.builder()
 *                     .aadAuthority("isbicanvfefdaci")
 *                     .applicationId("dibfqwjrnzikktkwe")
 *                     .audience("yrfxszjhkczoyfi")
 *                     .objectId("xfhhdosr")
 *                     .tenantId("uwceuawplakwjswbvllffbsz")
 *                     .build())
 *                 .customProperties()
 *                 .machineId("sihoniqzqfz")
 *                 .machineName("glhejppirkiamgxxro")
 *                 .build())
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key5560", "jgffrfcgjrm"))
 *             .build());
 *     }
 * }
 * ```
 * ### MigrateAgent_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateAgent = new AzureNative.Migrate.MigrateAgent("migrateAgent", new()
 *     {
 *         AgentName = "e85v",
 *         ModernizeProjectName = "l77ak",
 *         ResourceGroupName = "rgmigrateEngine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateAgent(ctx, "migrateAgent", &migrate.MigrateAgentArgs{
 * 			AgentName:            pulumi.String("e85v"),
 * 			ModernizeProjectName: pulumi.String("l77ak"),
 * 			ResourceGroupName:    pulumi.String("rgmigrateEngine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateAgent;
 * import com.pulumi.azurenative.migrate.MigrateAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateAgent = new MigrateAgent("migrateAgent", MigrateAgentArgs.builder()
 *             .agentName("e85v")
 *             .modernizeProjectName("l77ak")
 *             .resourceGroupName("rgmigrateEngine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MigrateAgent icysfvhjjgwhxx /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}/migrateAgents/{agentName}
 * ```
 */
public class MigrateAgent internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.MigrateAgent,
) : KotlinCustomResource(javaResource, MigrateAgentMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * MigrateAgent model properties.
     */
    public val properties: Output<MigrateAgentModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                migrateAgentModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<MigrateAgentModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                migrateAgentModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MigrateAgentMapper : ResourceMapper<MigrateAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.MigrateAgent::class == javaResource::class

    override fun map(javaResource: Resource): MigrateAgent = MigrateAgent(
        javaResource as
            com.pulumi.azurenative.migrate.MigrateAgent,
    )
}

/**
 * @see [MigrateAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MigrateAgent].
 */
public suspend fun migrateAgent(
    name: String,
    block: suspend MigrateAgentResourceBuilder.() -> Unit,
): MigrateAgent {
    val builder = MigrateAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MigrateAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migrateAgent(name: String): MigrateAgent {
    val builder = MigrateAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
