@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.ModernizeProjectModelPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.ModernizeProjectModelResponseSystemData
import com.pulumi.azurenative.migrate.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.ModernizeProjectModelPropertiesResponse.Companion.toKotlin as modernizeProjectModelPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.ModernizeProjectModelResponseSystemData.Companion.toKotlin as modernizeProjectModelResponseSystemDataToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin

/**
 * Builder for [ModernizeProject].
 */
@PulumiTagMarker
public class ModernizeProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModernizeProjectArgs = ModernizeProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModernizeProjectArgsBuilder.() -> Unit) {
        val builder = ModernizeProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ModernizeProject {
        val builtJavaResource = com.pulumi.azurenative.migrate.ModernizeProject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ModernizeProject(builtJavaResource)
    }
}

/**
 * ModernizeProject model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### ModernizeProject_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modernizeProject = new AzureNative.Migrate.ModernizeProject("modernizeProject", new()
 *     {
 *         Identity = new AzureNative.Migrate.Inputs.ResourceIdentityArgs
 *         {
 *             PrincipalId = "ins",
 *             TenantId = "fjnu",
 *             Type = AzureNative.Migrate.ResourceIdentityTypes.None,
 *             UserAssignedIdentities =
 *             {
 *                 { "key6848", new AzureNative.Migrate.Inputs.UserAssignedIdentityArgs
 *                 {
 *                     ClientId = "lvlngepacjdjryqmxuvfdxwtkc",
 *                     PrincipalId = "lumkynazsspljxiiwvz",
 *                 } },
 *             },
 *         },
 *         Location = "nbqyuxrgrlhx",
 *         ModernizeProjectName = "b",
 *         Properties = new AzureNative.Migrate.Inputs.ModernizeProjectModelPropertiesArgs
 *         {
 *             MigrationConfiguration = new AzureNative.Migrate.Inputs.MigrationConfigurationArgs
 *             {
 *                 KeyVaultResourceId = "vekhittkyogvwnqmggknv",
 *                 MigrationSolutionResourceId = "bglfkwtzvqmhwpddwpvtdzaleaioxo",
 *                 StorageAccountResourceId = "dgcoticysafrpynyoxkgrspooiia",
 *             },
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key8644", "wfyi" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewModernizeProject(ctx, "modernizeProject", &migrate.ModernizeProjectArgs{
 * 			Identity: &migrate.ResourceIdentityArgs{
 * 				PrincipalId: pulumi.String("ins"),
 * 				TenantId:    pulumi.String("fjnu"),
 * 				Type:        pulumi.String(migrate.ResourceIdentityTypesNone),
 * 				UserAssignedIdentities: migrate.UserAssignedIdentityMap{
 * 					"key6848": &migrate.UserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("lvlngepacjdjryqmxuvfdxwtkc"),
 * 						PrincipalId: pulumi.String("lumkynazsspljxiiwvz"),
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("nbqyuxrgrlhx"),
 * 			ModernizeProjectName: pulumi.String("b"),
 * 			Properties: &migrate.ModernizeProjectModelPropertiesArgs{
 * 				MigrationConfiguration: &migrate.MigrationConfigurationArgs{
 * 					KeyVaultResourceId:          pulumi.String("vekhittkyogvwnqmggknv"),
 * 					MigrationSolutionResourceId: pulumi.String("bglfkwtzvqmhwpddwpvtdzaleaioxo"),
 * 					StorageAccountResourceId:    pulumi.String("dgcoticysafrpynyoxkgrspooiia"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * 			Tags: pulumi.StringMap{
 * 				"key8644": pulumi.String("wfyi"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ModernizeProject;
 * import com.pulumi.azurenative.migrate.ModernizeProjectArgs;
 * import com.pulumi.azurenative.migrate.inputs.ResourceIdentityArgs;
 * import com.pulumi.azurenative.migrate.inputs.ModernizeProjectModelPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.MigrationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modernizeProject = new ModernizeProject("modernizeProject", ModernizeProjectArgs.builder()
 *             .identity(ResourceIdentityArgs.builder()
 *                 .principalId("ins")
 *                 .tenantId("fjnu")
 *                 .type("None")
 *                 .userAssignedIdentities(Map.of("key6848", Map.ofEntries(
 *                     Map.entry("clientId", "lvlngepacjdjryqmxuvfdxwtkc"),
 *                     Map.entry("principalId", "lumkynazsspljxiiwvz")
 *                 )))
 *                 .build())
 *             .location("nbqyuxrgrlhx")
 *             .modernizeProjectName("b")
 *             .properties(ModernizeProjectModelPropertiesArgs.builder()
 *                 .migrationConfiguration(MigrationConfigurationArgs.builder()
 *                     .keyVaultResourceId("vekhittkyogvwnqmggknv")
 *                     .migrationSolutionResourceId("bglfkwtzvqmhwpddwpvtdzaleaioxo")
 *                     .storageAccountResourceId("dgcoticysafrpynyoxkgrspooiia")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key8644", "wfyi"))
 *             .build());
 *     }
 * }
 * ```
 * ### ModernizeProject_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modernizeProject = new AzureNative.Migrate.ModernizeProject("modernizeProject", new()
 *     {
 *         ModernizeProjectName = "j",
 *         ResourceGroupName = "rgmigrateEngine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewModernizeProject(ctx, "modernizeProject", &migrate.ModernizeProjectArgs{
 * 			ModernizeProjectName: pulumi.String("j"),
 * 			ResourceGroupName:    pulumi.String("rgmigrateEngine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ModernizeProject;
 * import com.pulumi.azurenative.migrate.ModernizeProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modernizeProject = new ModernizeProject("modernizeProject", ModernizeProjectArgs.builder()
 *             .modernizeProjectName("j")
 *             .resourceGroupName("rgmigrateEngine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ModernizeProject qjtgfttacnihw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}
 * ```
 */
public class ModernizeProject internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.ModernizeProject,
) : KotlinCustomResource(javaResource, ModernizeProjectMapper) {
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the location of the modernizeProject.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ModernizeProject properties.
     */
    public val properties: Output<ModernizeProjectModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                modernizeProjectModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<ModernizeProjectModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                modernizeProjectModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ModernizeProjectMapper : ResourceMapper<ModernizeProject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.ModernizeProject::class == javaResource::class

    override fun map(javaResource: Resource): ModernizeProject = ModernizeProject(
        javaResource as
            com.pulumi.azurenative.migrate.ModernizeProject,
    )
}

/**
 * @see [ModernizeProject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ModernizeProject].
 */
public suspend fun modernizeProject(
    name: String,
    block: suspend ModernizeProjectResourceBuilder.() -> Unit,
): ModernizeProject {
    val builder = ModernizeProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ModernizeProject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun modernizeProject(name: String): ModernizeProject {
    val builder = ModernizeProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
