@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin as privateEndpointConnectionPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionControllerPrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionControllerPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs =
        PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionControllerPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionControllerPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionControllerPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )

        return PrivateEndpointConnectionControllerPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * REST model used to encapsulate the user visible state of a PrivateEndpoint.
 * Azure REST API version: 2020-05-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### PrivateEndpointConnection_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionControllerPrivateEndpointConnection = new AzureNative.Migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection("privateEndpointConnectionControllerPrivateEndpointConnection", new()
 *     {
 *         MigrateProjectName = "proj567",
 *         PeConnectionName = "proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6",
 *         Properties = new AzureNative.Migrate.Inputs.ConnectionStateRequestBodyPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.Migrate.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 ActionsRequired = "",
 *                 Status = AzureNative.Migrate.PrivateEndpointServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "pajindTest1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionControllerPrivateEndpointConnection(ctx, "privateEndpointConnectionControllerPrivateEndpointConnection", &migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs{
 * 			MigrateProjectName: pulumi.String("proj567"),
 * 			PeConnectionName:   pulumi.String("proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6"),
 * 			Properties: &migrate.ConnectionStateRequestBodyPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &migrate.PrivateLinkServiceConnectionStateArgs{
 * 					ActionsRequired: pulumi.String(""),
 * 					Status:          pulumi.String(migrate.PrivateEndpointServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.migrate.inputs.ConnectionStateRequestBodyPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionControllerPrivateEndpointConnection = new PrivateEndpointConnectionControllerPrivateEndpointConnection("privateEndpointConnectionControllerPrivateEndpointConnection", PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs.builder()
 *             .migrateProjectName("proj567")
 *             .peConnectionName("proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6")
 *             .properties(ConnectionStateRequestBodyPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                     .actionsRequired("")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("pajindTest1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnectionControllerPrivateEndpointConnection proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/privateEndpointConnections/{peConnectionName}
 * ```
 */
public class PrivateEndpointConnectionControllerPrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection,
) : KotlinCustomResource(
    javaResource,
    PrivateEndpointConnectionControllerPrivateEndpointConnectionMapper,
) {
    /**
     * Gets the tag for optimistic concurrency control.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * Gets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the properties of the object.
     */
    public val properties: Output<PrivateEndpointConnectionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointConnectionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionControllerPrivateEndpointConnectionMapper :
    ResourceMapper<PrivateEndpointConnectionControllerPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionControllerPrivateEndpointConnection =
        PrivateEndpointConnectionControllerPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection,
        )
}

/**
 * @see [PrivateEndpointConnectionControllerPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionControllerPrivateEndpointConnection].
 */
public suspend fun privateEndpointConnectionControllerPrivateEndpointConnection(
    name: String,
    block: suspend PrivateEndpointConnectionControllerPrivateEndpointConnectionResourceBuilder.() -> Unit,
): PrivateEndpointConnectionControllerPrivateEndpointConnection {
    val builder = PrivateEndpointConnectionControllerPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionControllerPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionControllerPrivateEndpointConnection(name: String): PrivateEndpointConnectionControllerPrivateEndpointConnection {
    val builder = PrivateEndpointConnectionControllerPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
