@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionOperation].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionOperationArgs = PrivateEndpointConnectionOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionOperationArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionOperation(builtJavaResource)
    }
}

/**
 * Private endpoint connection resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionOperations_Update_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionOperation = new AzureNative.Migrate.PrivateEndpointConnectionOperation("privateEndpointConnectionOperation", new()
 *     {
 *         PrivateEndpointConnectionName = "sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7",
 *         PrivateLinkServiceConnectionState = new AzureNative.Migrate.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "",
 *             Status = AzureNative.Migrate.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ProjectName = "sakanwar1204project",
 *         ResourceGroupName = "sakanwar",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionOperation(ctx, "privateEndpointConnectionOperation", &migrate.PrivateEndpointConnectionOperationArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7"),
 * 			PrivateLinkServiceConnectionState: &migrate.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String(""),
 * 				Status:          pulumi.String(migrate.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ProjectName:       pulumi.String("sakanwar1204project"),
 * 			ResourceGroupName: pulumi.String("sakanwar"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperation;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionOperation = new PrivateEndpointConnectionOperation("privateEndpointConnectionOperation", PrivateEndpointConnectionOperationArgs.builder()
 *             .privateEndpointConnectionName("sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .actionsRequired("")
 *                 .status("Approved")
 *                 .build())
 *             .projectName("sakanwar1204project")
 *             .resourceGroupName("sakanwar")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnectionOperation sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnectionOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperation,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionOperationMapper) {
    /**
     * The group ids for the private endpoint resource.
     */
    public val groupIds: Output<List<String>>
        get() = javaResource.groupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private endpoint resource.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionOperationMapper :
    ResourceMapper<PrivateEndpointConnectionOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperation::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionOperation =
        PrivateEndpointConnectionOperation(
            javaResource as
                com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperation,
        )
}

/**
 * @see [PrivateEndpointConnectionOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionOperation].
 */
public suspend fun privateEndpointConnectionOperation(
    name: String,
    block: suspend PrivateEndpointConnectionOperationResourceBuilder.() -> Unit,
): PrivateEndpointConnectionOperation {
    val builder = PrivateEndpointConnectionOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionOperation(name: String): PrivateEndpointConnectionOperation {
    val builder = PrivateEndpointConnectionOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
