@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.ProjectArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.ProjectPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.ProjectPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Migrate Project.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2018-02-02.
 * ## Example Usage
 * ### Projects_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var project = new AzureNative.Migrate.Project("project", new()
 *     {
 *         ETag = "",
 *         Location = "West Europe",
 *         ProjectName = "abGoyalProject2",
 *         Properties = new AzureNative.Migrate.Inputs.ProjectPropertiesArgs
 *         {
 *             AssessmentSolutionId = "/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourcegroups/abgoyal-westeurope/providers/microsoft.migrate/migrateprojects/abgoyalweselfhost/Solutions/Servers-Assessment-ServerAssessment",
 *             ProjectStatus = AzureNative.Migrate.ProjectStatus.Active,
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewProject(ctx, "project", &migrate.ProjectArgs{
 * 			ETag:        pulumi.String(""),
 * 			Location:    pulumi.String("West Europe"),
 * 			ProjectName: pulumi.String("abGoyalProject2"),
 * 			Properties: &migrate.ProjectPropertiesArgs{
 * 				AssessmentSolutionId: pulumi.String("/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourcegroups/abgoyal-westeurope/providers/microsoft.migrate/migrateprojects/abgoyalweselfhost/Solutions/Servers-Assessment-ServerAssessment"),
 * 				ProjectStatus:        pulumi.String(migrate.ProjectStatusActive),
 * 			},
 * 			ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * 			Tags:              pulumi.Any(nil),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Project;
 * import com.pulumi.azurenative.migrate.ProjectArgs;
 * import com.pulumi.azurenative.migrate.inputs.ProjectPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var project = new Project("project", ProjectArgs.builder()
 *             .eTag("")
 *             .location("West Europe")
 *             .projectName("abGoyalProject2")
 *             .properties(ProjectPropertiesArgs.builder()
 *                 .assessmentSolutionId("/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourcegroups/abgoyal-westeurope/providers/microsoft.migrate/migrateprojects/abgoyalweselfhost/Solutions/Servers-Assessment-ServerAssessment")
 *                 .projectStatus("Active")
 *                 .build())
 *             .resourceGroupName("abgoyal-westEurope")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Project abGoyalProject2 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}
 * ```
 * @property eTag For optimistic concurrency control.
 * @property location Azure location in which project is created.
 * @property projectName Name of the Azure Migrate project.
 * @property properties Properties of the project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property tags Tags provided by Azure Tagging service.
 */
public data class ProjectArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<ProjectPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.ProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.ProjectArgs =
        com.pulumi.azurenative.migrate.ProjectArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<ProjectPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Any>? = null

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("wnvxwkxjqaltonxh")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Azure location in which project is created.
     */
    @JvmName("minlitvskdyrmpvg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("maifdvtyrcrhbrma")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Properties of the project.
     */
    @JvmName("waasyogbjfrjisen")
    public suspend fun properties(`value`: Output<ProjectPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("qbhuaupqfkuubqyg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags provided by Azure Tagging service.
     */
    @JvmName("tnpxrqngdtepdaqu")
    public suspend fun tags(`value`: Output<Any>) {
        this.tags = value
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("kwdwquhjycrfsaxv")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Azure location in which project is created.
     */
    @JvmName("ihekuebhomtmauch")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("vpaxqhbokpjmbwdd")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Properties of the project.
     */
    @JvmName("aunefvutcdaapdkt")
    public suspend fun properties(`value`: ProjectPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the project.
     */
    @JvmName("uprvljxxpvbqyoqd")
    public suspend fun properties(argument: suspend ProjectPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("apktugjusmkliyvr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags provided by Azure Tagging service.
     */
    @JvmName("hqqatnxpwtxiuenu")
    public suspend fun tags(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        eTag = eTag,
        location = location,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
