@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse.Companion.toKotlin as collectorAgentPropertiesBaseResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ServerCollectorsOperation].
 */
@PulumiTagMarker
public class ServerCollectorsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerCollectorsOperationArgs = ServerCollectorsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerCollectorsOperationArgsBuilder.() -> Unit) {
        val builder = ServerCollectorsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerCollectorsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.ServerCollectorsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerCollectorsOperation(builtJavaResource)
    }
}

/**
 * Physical server collector resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### ServerCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverCollectorsOperation = new AzureNative.Migrate.ServerCollectorsOperation("serverCollectorsOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "498e4965-bbb1-47c2-8613-345baff9c509",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "65153d2f-9afb-44e8-b3ca-1369150b7354",
 *                 Audience = "65153d2f-9afb-44e8-b3ca-1369150b7354",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "ddde6f96-87c8-420b-9d4d-f16a5090519e",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/ServerSites/walter7155site",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ResourceGroupName = "ayagrawRG",
 *         ServerCollectorName = "walter389fcollector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewServerCollectorsOperation(ctx, "serverCollectorsOperation", &migrate.ServerCollectorsOperationArgs{
 * 			AgentProperties: &migrate.CollectorAgentPropertiesBaseArgs{
 * 				Id: pulumi.String("498e4965-bbb1-47c2-8613-345baff9c509"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("65153d2f-9afb-44e8-b3ca-1369150b7354"),
 * 					Audience:      pulumi.String("65153d2f-9afb-44e8-b3ca-1369150b7354"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("ddde6f96-87c8-420b-9d4d-f16a5090519e"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/ServerSites/walter7155site"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 			ServerCollectorName: pulumi.String("walter389fcollector"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ServerCollectorsOperation;
 * import com.pulumi.azurenative.migrate.ServerCollectorsOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverCollectorsOperation = new ServerCollectorsOperation("serverCollectorsOperation", ServerCollectorsOperationArgs.builder()
 *             .agentProperties(CollectorAgentPropertiesBaseArgs.builder()
 *                 .id("498e4965-bbb1-47c2-8613-345baff9c509")
 *                 .spnDetails(CollectorAgentSpnPropertiesBaseArgs.builder()
 *                     .applicationId("65153d2f-9afb-44e8-b3ca-1369150b7354")
 *                     .audience("65153d2f-9afb-44e8-b3ca-1369150b7354")
 *                     .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .objectId("ddde6f96-87c8-420b-9d4d-f16a5090519e")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .build())
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/ServerSites/walter7155site")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .serverCollectorName("walter389fcollector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ServerCollectorsOperation walter389fcollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}
 * ```
 */
public class ServerCollectorsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.ServerCollectorsOperation,
) : KotlinCustomResource(javaResource, ServerCollectorsOperationMapper) {
    /**
     * Gets or sets the collector agent properties.
     */
    public val agentProperties: Output<CollectorAgentPropertiesBaseResponse>?
        get() = javaResource.agentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> collectorAgentPropertiesBaseResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the Timestamp when collector was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the discovery site id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Timestamp when collector was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object ServerCollectorsOperationMapper : ResourceMapper<ServerCollectorsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.ServerCollectorsOperation::class == javaResource::class

    override fun map(javaResource: Resource): ServerCollectorsOperation =
        ServerCollectorsOperation(
            javaResource as
                com.pulumi.azurenative.migrate.ServerCollectorsOperation,
        )
}

/**
 * @see [ServerCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerCollectorsOperation].
 */
public suspend fun serverCollectorsOperation(
    name: String,
    block: suspend ServerCollectorsOperationResourceBuilder.() -> Unit,
): ServerCollectorsOperation {
    val builder = ServerCollectorsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverCollectorsOperation(name: String): ServerCollectorsOperation {
    val builder = ServerCollectorsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
