@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.ServerCollectorsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Physical server collector resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### ServerCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverCollectorsOperation = new AzureNative.Migrate.ServerCollectorsOperation("serverCollectorsOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "498e4965-bbb1-47c2-8613-345baff9c509",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "65153d2f-9afb-44e8-b3ca-1369150b7354",
 *                 Audience = "65153d2f-9afb-44e8-b3ca-1369150b7354",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "ddde6f96-87c8-420b-9d4d-f16a5090519e",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/ServerSites/walter7155site",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ResourceGroupName = "ayagrawRG",
 *         ServerCollectorName = "walter389fcollector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewServerCollectorsOperation(ctx, "serverCollectorsOperation", &migrate.ServerCollectorsOperationArgs{
 * 			AgentProperties: &migrate.CollectorAgentPropertiesBaseArgs{
 * 				Id: pulumi.String("498e4965-bbb1-47c2-8613-345baff9c509"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("65153d2f-9afb-44e8-b3ca-1369150b7354"),
 * 					Audience:      pulumi.String("65153d2f-9afb-44e8-b3ca-1369150b7354"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("ddde6f96-87c8-420b-9d4d-f16a5090519e"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/ServerSites/walter7155site"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 			ServerCollectorName: pulumi.String("walter389fcollector"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ServerCollectorsOperation;
 * import com.pulumi.azurenative.migrate.ServerCollectorsOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverCollectorsOperation = new ServerCollectorsOperation("serverCollectorsOperation", ServerCollectorsOperationArgs.builder()
 *             .agentProperties(CollectorAgentPropertiesBaseArgs.builder()
 *                 .id("498e4965-bbb1-47c2-8613-345baff9c509")
 *                 .spnDetails(CollectorAgentSpnPropertiesBaseArgs.builder()
 *                     .applicationId("65153d2f-9afb-44e8-b3ca-1369150b7354")
 *                     .audience("65153d2f-9afb-44e8-b3ca-1369150b7354")
 *                     .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .objectId("ddde6f96-87c8-420b-9d4d-f16a5090519e")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .build())
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/ServerSites/walter7155site")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .serverCollectorName("walter389fcollector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ServerCollectorsOperation walter389fcollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}
 * ```
 * @property agentProperties Gets or sets the collector agent properties.
 * @property discoverySiteId Gets the discovery site id.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverCollectorName Physical server collector ARM name
 */
public data class ServerCollectorsOperationArgs(
    public val agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverCollectorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.ServerCollectorsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.ServerCollectorsOperationArgs =
        com.pulumi.azurenative.migrate.ServerCollectorsOperationArgs.builder()
            .agentProperties(agentProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverCollectorName(serverCollectorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerCollectorsOperationArgs].
 */
@PulumiTagMarker
public class ServerCollectorsOperationArgsBuilder internal constructor() {
    private var agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null

    private var discoverySiteId: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverCollectorName: Output<String>? = null

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("kpmoienfoovsidol")
    public suspend fun agentProperties(`value`: Output<CollectorAgentPropertiesBaseArgs>) {
        this.agentProperties = value
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("fluiqwacxtuquexi")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("rdyyviqahmktdgay")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mfodlrakuutjfqfi")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gjdcnjjvopxjufxi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Physical server collector ARM name
     */
    @JvmName("cjetultvpmbdghhy")
    public suspend fun serverCollectorName(`value`: Output<String>) {
        this.serverCollectorName = value
    }

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("ehuxhvrsigsvbony")
    public suspend fun agentProperties(`value`: CollectorAgentPropertiesBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProperties = mapped
    }

    /**
     * @param argument Gets or sets the collector agent properties.
     */
    @JvmName("jwffrhguqslbnqqi")
    public suspend fun agentProperties(argument: suspend CollectorAgentPropertiesBaseArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentPropertiesBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentProperties = mapped
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("rqbakutajlaspcko")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("joppdkhkfwgulgul")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ggonbpaijtddutbp")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("yikkjcyhisulcrwh")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mldxccdyfywrpceu")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qxtnhslxyprfuocd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Physical server collector ARM name
     */
    @JvmName("orwiwrhsclvhbqcq")
    public suspend fun serverCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCollectorName = mapped
    }

    internal fun build(): ServerCollectorsOperationArgs = ServerCollectorsOperationArgs(
        agentProperties = agentProperties,
        discoverySiteId = discoverySiteId,
        projectName = projectName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        serverCollectorName = serverCollectorName,
    )
}
