@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.SqlAssessmentV2OperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentSizingCriterion
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentType
import com.pulumi.azurenative.migrate.kotlin.enums.AsyncCommitModeIntent
import com.pulumi.azurenative.migrate.kotlin.enums.AzureCurrency
import com.pulumi.azurenative.migrate.kotlin.enums.AzureLocation
import com.pulumi.azurenative.migrate.kotlin.enums.AzureOfferCode
import com.pulumi.azurenative.migrate.kotlin.enums.AzureReservedInstance
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSecurityOfferingType
import com.pulumi.azurenative.migrate.kotlin.enums.EnvironmentType
import com.pulumi.azurenative.migrate.kotlin.enums.GroupType
import com.pulumi.azurenative.migrate.kotlin.enums.MultiSubnetIntent
import com.pulumi.azurenative.migrate.kotlin.enums.OptimizationLogic
import com.pulumi.azurenative.migrate.kotlin.enums.OsLicense
import com.pulumi.azurenative.migrate.kotlin.enums.Percentile
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.enums.SqlServerLicense
import com.pulumi.azurenative.migrate.kotlin.enums.TimeRange
import com.pulumi.azurenative.migrate.kotlin.inputs.EntityUptimeArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.EntityUptimeArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.SqlDbSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.SqlDbSettingsArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.SqlMiSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.SqlMiSettingsArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.SqlVmSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.SqlVmSettingsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SQL Assessment REST resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### SqlAssessmentV2Operations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlAssessmentV2Operation = new AzureNative.Migrate.SqlAssessmentV2Operation("sqlAssessmentV2Operation", new()
 *     {
 *         AssessmentName = "test_swagger_1",
 *         AsyncCommitModeIntent = AzureNative.Migrate.AsyncCommitModeIntent.DisasterRecovery,
 *         AzureLocation = "SoutheastAsia",
 *         AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Msazr0003P,
 *         AzureOfferCodeForVm = AzureNative.Migrate.AzureOfferCode.Msazr0003P,
 *         AzureSqlDatabaseSettings = new AzureNative.Migrate.Inputs.SqlDbSettingsArgs
 *         {
 *             AzureSqlComputeTier = AzureNative.Migrate.ComputeTier.Automatic,
 *             AzureSqlDataBaseType = AzureNative.Migrate.AzureSqlDataBaseType.SingleDatabase,
 *             AzureSqlPurchaseModel = AzureNative.Migrate.AzureSqlPurchaseModel.VCore,
 *             AzureSqlServiceTier = AzureNative.Migrate.AzureSqlServiceTier.Automatic,
 *         },
 *         AzureSqlManagedInstanceSettings = new AzureNative.Migrate.Inputs.SqlMiSettingsArgs
 *         {
 *             AzureSqlInstanceType = AzureNative.Migrate.AzureSqlInstanceType.SingleInstance,
 *             AzureSqlServiceTier = AzureNative.Migrate.AzureSqlServiceTier.Automatic,
 *         },
 *         AzureSqlVmSettings = new AzureNative.Migrate.Inputs.SqlVmSettingsArgs
 *         {
 *             InstanceSeries = new[]
 *             {
 *                 AzureNative.Migrate.AzureVmFamily.Eadsv5Series,
 *             },
 *         },
 *         Currency = AzureNative.Migrate.AzureCurrency.USD,
 *         DisasterRecoveryLocation = AzureNative.Migrate.AzureLocation.EastAsia,
 *         DiscountPercentage = 0,
 *         EnableHadrAssessment = true,
 *         EntityUptime = new AzureNative.Migrate.Inputs.EntityUptimeArgs
 *         {
 *             DaysPerMonth = 30,
 *             HoursPerDay = 24,
 *         },
 *         EnvironmentType = AzureNative.Migrate.EnvironmentType.Production,
 *         GroupName = "test_fci_hadr",
 *         MultiSubnetIntent = AzureNative.Migrate.MultiSubnetIntent.DisasterRecovery,
 *         OptimizationLogic = AzureNative.Migrate.OptimizationLogic.MinimizeCost,
 *         OsLicense = AzureNative.Migrate.OsLicense.Unknown,
 *         Percentile = AzureNative.Migrate.Percentile.Percentile95,
 *         ProjectName = "fci-test6904project",
 *         ReservedInstance = AzureNative.Migrate.AzureReservedInstance.None,
 *         ReservedInstanceForVm = AzureNative.Migrate.AzureReservedInstance.None,
 *         ResourceGroupName = "rgmigrate",
 *         ScalingFactor = 1,
 *         SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *         SqlServerLicense = AzureNative.Migrate.SqlServerLicense.Unknown,
 *         TimeRange = AzureNative.Migrate.TimeRange.Day,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSqlAssessmentV2Operation(ctx, "sqlAssessmentV2Operation", &migrate.SqlAssessmentV2OperationArgs{
 * 			AssessmentName:        pulumi.String("test_swagger_1"),
 * 			AsyncCommitModeIntent: pulumi.String(migrate.AsyncCommitModeIntentDisasterRecovery),
 * 			AzureLocation:         pulumi.String("SoutheastAsia"),
 * 			AzureOfferCode:        pulumi.String(migrate.AzureOfferCodeMsazr0003P),
 * 			AzureOfferCodeForVm:   pulumi.String(migrate.AzureOfferCodeMsazr0003P),
 * 			AzureSqlDatabaseSettings: &migrate.SqlDbSettingsArgs{
 * 				AzureSqlComputeTier:   pulumi.String(migrate.ComputeTierAutomatic),
 * 				AzureSqlDataBaseType:  pulumi.String(migrate.AzureSqlDataBaseTypeSingleDatabase),
 * 				AzureSqlPurchaseModel: pulumi.String(migrate.AzureSqlPurchaseModelVCore),
 * 				AzureSqlServiceTier:   pulumi.String(migrate.AzureSqlServiceTierAutomatic),
 * 			},
 * 			AzureSqlManagedInstanceSettings: &migrate.SqlMiSettingsArgs{
 * 				AzureSqlInstanceType: pulumi.String(migrate.AzureSqlInstanceTypeSingleInstance),
 * 				AzureSqlServiceTier:  pulumi.String(migrate.AzureSqlServiceTierAutomatic),
 * 			},
 * 			AzureSqlVmSettings: &migrate.SqlVmSettingsArgs{
 * 				InstanceSeries: pulumi.StringArray{
 * 					pulumi.String(migrate.AzureVmFamilyEadsv5Series),
 * 				},
 * 			},
 * 			Currency:                 pulumi.String(migrate.AzureCurrencyUSD),
 * 			DisasterRecoveryLocation: pulumi.String(migrate.AzureLocationEastAsia),
 * 			DiscountPercentage:       pulumi.Float64(0),
 * 			EnableHadrAssessment:     pulumi.Bool(true),
 * 			EntityUptime: &migrate.EntityUptimeArgs{
 * 				DaysPerMonth: pulumi.Int(30),
 * 				HoursPerDay:  pulumi.Int(24),
 * 			},
 * 			EnvironmentType:       pulumi.String(migrate.EnvironmentTypeProduction),
 * 			GroupName:             pulumi.String("test_fci_hadr"),
 * 			MultiSubnetIntent:     pulumi.String(migrate.MultiSubnetIntentDisasterRecovery),
 * 			OptimizationLogic:     pulumi.String(migrate.OptimizationLogicMinimizeCost),
 * 			OsLicense:             pulumi.String(migrate.OsLicenseUnknown),
 * 			Percentile:            pulumi.String(migrate.PercentilePercentile95),
 * 			ProjectName:           pulumi.String("fci-test6904project"),
 * 			ReservedInstance:      pulumi.String(migrate.AzureReservedInstanceNone),
 * 			ReservedInstanceForVm: pulumi.String(migrate.AzureReservedInstanceNone),
 * 			ResourceGroupName:     pulumi.String("rgmigrate"),
 * 			ScalingFactor:         pulumi.Float64(1),
 * 			SizingCriterion:       pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 			SqlServerLicense:      pulumi.String(migrate.SqlServerLicenseUnknown),
 * 			TimeRange:             pulumi.String(migrate.TimeRangeDay),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SqlAssessmentV2Operation;
 * import com.pulumi.azurenative.migrate.SqlAssessmentV2OperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.SqlDbSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.SqlMiSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.SqlVmSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.EntityUptimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlAssessmentV2Operation = new SqlAssessmentV2Operation("sqlAssessmentV2Operation", SqlAssessmentV2OperationArgs.builder()
 *             .assessmentName("test_swagger_1")
 *             .asyncCommitModeIntent("DisasterRecovery")
 *             .azureLocation("SoutheastAsia")
 *             .azureOfferCode("MSAZR0003P")
 *             .azureOfferCodeForVm("MSAZR0003P")
 *             .azureSqlDatabaseSettings(SqlDbSettingsArgs.builder()
 *                 .azureSqlComputeTier("Automatic")
 *                 .azureSqlDataBaseType("SingleDatabase")
 *                 .azureSqlPurchaseModel("VCore")
 *                 .azureSqlServiceTier("Automatic")
 *                 .build())
 *             .azureSqlManagedInstanceSettings(SqlMiSettingsArgs.builder()
 *                 .azureSqlInstanceType("SingleInstance")
 *                 .azureSqlServiceTier("Automatic")
 *                 .build())
 *             .azureSqlVmSettings(SqlVmSettingsArgs.builder()
 *                 .instanceSeries("Eadsv5_series")
 *                 .build())
 *             .currency("USD")
 *             .disasterRecoveryLocation("EastAsia")
 *             .discountPercentage(0)
 *             .enableHadrAssessment(true)
 *             .entityUptime(EntityUptimeArgs.builder()
 *                 .daysPerMonth(30)
 *                 .hoursPerDay(24)
 *                 .build())
 *             .environmentType("Production")
 *             .groupName("test_fci_hadr")
 *             .multiSubnetIntent("DisasterRecovery")
 *             .optimizationLogic("MinimizeCost")
 *             .osLicense("Unknown")
 *             .percentile("Percentile95")
 *             .projectName("fci-test6904project")
 *             .reservedInstance("None")
 *             .reservedInstanceForVm("None")
 *             .resourceGroupName("rgmigrate")
 *             .scalingFactor(1)
 *             .sizingCriterion("PerformanceBased")
 *             .sqlServerLicense("Unknown")
 *             .timeRange("Day")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:SqlAssessmentV2Operation test_swagger_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/sqlAssessments/{assessmentName}
 * ```
 * @property assessmentName SQL Assessment arm name.
 * @property assessmentType Assessment type of the assessment.
 * @property asyncCommitModeIntent Gets or sets user preference indicating intent of async commit mode.
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer Code.
 * @property azureOfferCodeForVm Gets or sets Azure Offer Code for VM.
 * @property azureSecurityOfferingType Gets or sets a value indicating azure security offering type.
 * @property azureSqlDatabaseSettings Gets or sets user configurable SQL database settings.
 * @property azureSqlManagedInstanceSettings Gets or sets user configurable SQL managed instance settings.
 * @property azureSqlVmSettings Gets or sets user configurable SQL VM settings.
 * @property confidenceRatingInPercentage Confidence Rating in Percentage.
 * @property currency Currency in which prices should be reported.
 * @property disasterRecoveryLocation Gets or sets the Azure Location or Azure region where to which the machines
 * will be migrated.
 * @property discountPercentage Custom discount percentage.
 * @property eaSubscriptionId Gets or sets the Enterprise agreement subscription id.
 * @property enableHadrAssessment Gets or sets a value indicating whether HADR assessments needs to be created.
 * @property entityUptime Gets or sets the duration for which the entity (SQL, VMs) are up in the
 * on-premises environment.
 * @property environmentType Gets or sets user configurable setting to display the environment type.
 * @property groupName Group ARM name
 * @property groupType Gets the group type for the assessment.
 * @property isInternetAccessAvailable Gets or sets a value indicating whether internet access is available.
 * @property multiSubnetIntent Gets or sets user preference indicating intent of multi-subnet configuration.
 * @property optimizationLogic Gets or sets SQL optimization logic.
 * @property osLicense Gets or sets user configurable setting to display the azure hybrid use benefit.
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property reservedInstance Reserved instance.
 * @property reservedInstanceForVm Gets or sets azure reserved instance for VM.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property sizingCriterion Assessment sizing criterion.
 * @property sqlServerLicense SQL server license.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 */
public data class SqlAssessmentV2OperationArgs(
    public val assessmentName: Output<String>? = null,
    public val assessmentType: Output<Either<String, AssessmentType>>? = null,
    public val asyncCommitModeIntent: Output<Either<String, AsyncCommitModeIntent>>? = null,
    public val azureLocation: Output<String>? = null,
    public val azureOfferCode: Output<Either<String, AzureOfferCode>>? = null,
    public val azureOfferCodeForVm: Output<Either<String, AzureOfferCode>>? = null,
    public val azureSecurityOfferingType: Output<Either<String, AzureSecurityOfferingType>>? = null,
    public val azureSqlDatabaseSettings: Output<SqlDbSettingsArgs>? = null,
    public val azureSqlManagedInstanceSettings: Output<SqlMiSettingsArgs>? = null,
    public val azureSqlVmSettings: Output<SqlVmSettingsArgs>? = null,
    public val confidenceRatingInPercentage: Output<Double>? = null,
    public val currency: Output<Either<String, AzureCurrency>>? = null,
    public val disasterRecoveryLocation: Output<Either<String, AzureLocation>>? = null,
    public val discountPercentage: Output<Double>? = null,
    public val eaSubscriptionId: Output<String>? = null,
    public val enableHadrAssessment: Output<Boolean>? = null,
    public val entityUptime: Output<EntityUptimeArgs>? = null,
    public val environmentType: Output<Either<String, EnvironmentType>>? = null,
    public val groupName: Output<String>? = null,
    public val groupType: Output<Either<String, GroupType>>? = null,
    public val isInternetAccessAvailable: Output<Boolean>? = null,
    public val multiSubnetIntent: Output<Either<String, MultiSubnetIntent>>? = null,
    public val optimizationLogic: Output<Either<String, OptimizationLogic>>? = null,
    public val osLicense: Output<Either<String, OsLicense>>? = null,
    public val percentile: Output<Either<String, Percentile>>? = null,
    public val perfDataEndTime: Output<String>? = null,
    public val perfDataStartTime: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val reservedInstance: Output<Either<String, AzureReservedInstance>>? = null,
    public val reservedInstanceForVm: Output<Either<String, AzureReservedInstance>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingFactor: Output<Double>? = null,
    public val sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null,
    public val sqlServerLicense: Output<Either<String, SqlServerLicense>>? = null,
    public val timeRange: Output<Either<String, TimeRange>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.SqlAssessmentV2OperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.SqlAssessmentV2OperationArgs =
        com.pulumi.azurenative.migrate.SqlAssessmentV2OperationArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .assessmentType(
                assessmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .asyncCommitModeIntent(
                asyncCommitModeIntent?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureLocation(azureLocation?.applyValue({ args0 -> args0 }))
            .azureOfferCode(
                azureOfferCode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureOfferCodeForVm(
                azureOfferCodeForVm?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureSecurityOfferingType(
                azureSecurityOfferingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureSqlDatabaseSettings(
                azureSqlDatabaseSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .azureSqlManagedInstanceSettings(
                azureSqlManagedInstanceSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .azureSqlVmSettings(
                azureSqlVmSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .confidenceRatingInPercentage(confidenceRatingInPercentage?.applyValue({ args0 -> args0 }))
            .currency(
                currency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disasterRecoveryLocation(
                disasterRecoveryLocation?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .discountPercentage(discountPercentage?.applyValue({ args0 -> args0 }))
            .eaSubscriptionId(eaSubscriptionId?.applyValue({ args0 -> args0 }))
            .enableHadrAssessment(enableHadrAssessment?.applyValue({ args0 -> args0 }))
            .entityUptime(entityUptime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentType(
                environmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .groupType(
                groupType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .isInternetAccessAvailable(isInternetAccessAvailable?.applyValue({ args0 -> args0 }))
            .multiSubnetIntent(
                multiSubnetIntent?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .optimizationLogic(
                optimizationLogic?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .osLicense(
                osLicense?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .percentile(
                percentile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .perfDataEndTime(perfDataEndTime?.applyValue({ args0 -> args0 }))
            .perfDataStartTime(perfDataStartTime?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .reservedInstance(
                reservedInstance?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .reservedInstanceForVm(
                reservedInstanceForVm?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingFactor(scalingFactor?.applyValue({ args0 -> args0 }))
            .sizingCriterion(
                sizingCriterion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sqlServerLicense(
                sqlServerLicense?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .timeRange(
                timeRange?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlAssessmentV2OperationArgs].
 */
@PulumiTagMarker
public class SqlAssessmentV2OperationArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var assessmentType: Output<Either<String, AssessmentType>>? = null

    private var asyncCommitModeIntent: Output<Either<String, AsyncCommitModeIntent>>? = null

    private var azureLocation: Output<String>? = null

    private var azureOfferCode: Output<Either<String, AzureOfferCode>>? = null

    private var azureOfferCodeForVm: Output<Either<String, AzureOfferCode>>? = null

    private var azureSecurityOfferingType: Output<Either<String, AzureSecurityOfferingType>>? = null

    private var azureSqlDatabaseSettings: Output<SqlDbSettingsArgs>? = null

    private var azureSqlManagedInstanceSettings: Output<SqlMiSettingsArgs>? = null

    private var azureSqlVmSettings: Output<SqlVmSettingsArgs>? = null

    private var confidenceRatingInPercentage: Output<Double>? = null

    private var currency: Output<Either<String, AzureCurrency>>? = null

    private var disasterRecoveryLocation: Output<Either<String, AzureLocation>>? = null

    private var discountPercentage: Output<Double>? = null

    private var eaSubscriptionId: Output<String>? = null

    private var enableHadrAssessment: Output<Boolean>? = null

    private var entityUptime: Output<EntityUptimeArgs>? = null

    private var environmentType: Output<Either<String, EnvironmentType>>? = null

    private var groupName: Output<String>? = null

    private var groupType: Output<Either<String, GroupType>>? = null

    private var isInternetAccessAvailable: Output<Boolean>? = null

    private var multiSubnetIntent: Output<Either<String, MultiSubnetIntent>>? = null

    private var optimizationLogic: Output<Either<String, OptimizationLogic>>? = null

    private var osLicense: Output<Either<String, OsLicense>>? = null

    private var percentile: Output<Either<String, Percentile>>? = null

    private var perfDataEndTime: Output<String>? = null

    private var perfDataStartTime: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var reservedInstance: Output<Either<String, AzureReservedInstance>>? = null

    private var reservedInstanceForVm: Output<Either<String, AzureReservedInstance>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingFactor: Output<Double>? = null

    private var sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null

    private var sqlServerLicense: Output<Either<String, SqlServerLicense>>? = null

    private var timeRange: Output<Either<String, TimeRange>>? = null

    /**
     * @param value SQL Assessment arm name.
     */
    @JvmName("bgqeofaefchehcqw")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("ccoivvtsmvgatkxw")
    public suspend fun assessmentType(`value`: Output<Either<String, AssessmentType>>) {
        this.assessmentType = value
    }

    /**
     * @param value Gets or sets user preference indicating intent of async commit mode.
     */
    @JvmName("hbrkwebufldamvuj")
    public suspend fun asyncCommitModeIntent(`value`: Output<Either<String, AsyncCommitModeIntent>>) {
        this.asyncCommitModeIntent = value
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("lrfxihkdhonkgxri")
    public suspend fun azureLocation(`value`: Output<String>) {
        this.azureLocation = value
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("adijljacbfhgmode")
    public suspend fun azureOfferCode(`value`: Output<Either<String, AzureOfferCode>>) {
        this.azureOfferCode = value
    }

    /**
     * @param value Gets or sets Azure Offer Code for VM.
     */
    @JvmName("thlptdeevemexnsg")
    public suspend fun azureOfferCodeForVm(`value`: Output<Either<String, AzureOfferCode>>) {
        this.azureOfferCodeForVm = value
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("gpiawvwjcjtrkuas")
    public suspend fun azureSecurityOfferingType(`value`: Output<Either<String, AzureSecurityOfferingType>>) {
        this.azureSecurityOfferingType = value
    }

    /**
     * @param value Gets or sets user configurable SQL database settings.
     */
    @JvmName("rjyxajnefpneaxvf")
    public suspend fun azureSqlDatabaseSettings(`value`: Output<SqlDbSettingsArgs>) {
        this.azureSqlDatabaseSettings = value
    }

    /**
     * @param value Gets or sets user configurable SQL managed instance settings.
     */
    @JvmName("qoacssaevuuujxdt")
    public suspend fun azureSqlManagedInstanceSettings(`value`: Output<SqlMiSettingsArgs>) {
        this.azureSqlManagedInstanceSettings = value
    }

    /**
     * @param value Gets or sets user configurable SQL VM settings.
     */
    @JvmName("tgkutvoqanrgekgp")
    public suspend fun azureSqlVmSettings(`value`: Output<SqlVmSettingsArgs>) {
        this.azureSqlVmSettings = value
    }

    /**
     * @param value Confidence Rating in Percentage.
     */
    @JvmName("fxjwxhrsrugotkfn")
    public suspend fun confidenceRatingInPercentage(`value`: Output<Double>) {
        this.confidenceRatingInPercentage = value
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("ooewovqhfqlfwava")
    public suspend fun currency(`value`: Output<Either<String, AzureCurrency>>) {
        this.currency = value
    }

    /**
     * @param value Gets or sets the Azure Location or Azure region where to which the machines
     * will be migrated.
     */
    @JvmName("pyrsdkwqljulrrxc")
    public suspend fun disasterRecoveryLocation(`value`: Output<Either<String, AzureLocation>>) {
        this.disasterRecoveryLocation = value
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("oqwlhepvckvfwqsm")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Gets or sets the Enterprise agreement subscription id.
     */
    @JvmName("gsnijjkuftwpeomo")
    public suspend fun eaSubscriptionId(`value`: Output<String>) {
        this.eaSubscriptionId = value
    }

    /**
     * @param value Gets or sets a value indicating whether HADR assessments needs to be created.
     */
    @JvmName("ayqijpmrnjtegvwp")
    public suspend fun enableHadrAssessment(`value`: Output<Boolean>) {
        this.enableHadrAssessment = value
    }

    /**
     * @param value Gets or sets the duration for which the entity (SQL, VMs) are up in the
     * on-premises environment.
     */
    @JvmName("fktrawuwnjuvcuvk")
    public suspend fun entityUptime(`value`: Output<EntityUptimeArgs>) {
        this.entityUptime = value
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("gdajpnqgvaswrqnl")
    public suspend fun environmentType(`value`: Output<Either<String, EnvironmentType>>) {
        this.environmentType = value
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("ncygngmvkkyfyame")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("jmovpkywspxhtdfn")
    public suspend fun groupType(`value`: Output<Either<String, GroupType>>) {
        this.groupType = value
    }

    /**
     * @param value Gets or sets a value indicating whether internet access is available.
     */
    @JvmName("idajvuebmgckxkjs")
    public suspend fun isInternetAccessAvailable(`value`: Output<Boolean>) {
        this.isInternetAccessAvailable = value
    }

    /**
     * @param value Gets or sets user preference indicating intent of multi-subnet configuration.
     */
    @JvmName("gkebfppbpglpammf")
    public suspend fun multiSubnetIntent(`value`: Output<Either<String, MultiSubnetIntent>>) {
        this.multiSubnetIntent = value
    }

    /**
     * @param value Gets or sets SQL optimization logic.
     */
    @JvmName("aclmxlefcotsilcg")
    public suspend fun optimizationLogic(`value`: Output<Either<String, OptimizationLogic>>) {
        this.optimizationLogic = value
    }

    /**
     * @param value Gets or sets user configurable setting to display the azure hybrid use benefit.
     */
    @JvmName("qynackcnvvuoxdhu")
    public suspend fun osLicense(`value`: Output<Either<String, OsLicense>>) {
        this.osLicense = value
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("iousqmhgwbflifvp")
    public suspend fun percentile(`value`: Output<Either<String, Percentile>>) {
        this.percentile = value
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("fnhxdrppslfdvtvc")
    public suspend fun perfDataEndTime(`value`: Output<String>) {
        this.perfDataEndTime = value
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("srxcdgjtgbksspkm")
    public suspend fun perfDataStartTime(`value`: Output<String>) {
        this.perfDataStartTime = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("sfnmvvlkfltgoqwk")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("yxmebxetthnfpaaf")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("mtujgmhxlyckxthh")
    public suspend fun reservedInstance(`value`: Output<Either<String, AzureReservedInstance>>) {
        this.reservedInstance = value
    }

    /**
     * @param value Gets or sets azure reserved instance for VM.
     */
    @JvmName("vlsrifysggskuypl")
    public suspend fun reservedInstanceForVm(`value`: Output<Either<String, AzureReservedInstance>>) {
        this.reservedInstanceForVm = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iqppcwytoggsertj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("nbsxqqfkntbhafac")
    public suspend fun scalingFactor(`value`: Output<Double>) {
        this.scalingFactor = value
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("tppptjfkdqwafppb")
    public suspend fun sizingCriterion(`value`: Output<Either<String, AssessmentSizingCriterion>>) {
        this.sizingCriterion = value
    }

    /**
     * @param value SQL server license.
     */
    @JvmName("tjqiymovntgyxlrb")
    public suspend fun sqlServerLicense(`value`: Output<Either<String, SqlServerLicense>>) {
        this.sqlServerLicense = value
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("poyhxexvklrwnbbc")
    public suspend fun timeRange(`value`: Output<Either<String, TimeRange>>) {
        this.timeRange = value
    }

    /**
     * @param value SQL Assessment arm name.
     */
    @JvmName("vljwkwxlqgyvljqy")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("skatjugydbyaxmhy")
    public suspend fun assessmentType(`value`: Either<String, AssessmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("kdhatdtdykhixbti")
    public fun assessmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("jkaficecogcvhblm")
    public fun assessmentType(`value`: AssessmentType) {
        val toBeMapped = Either.ofRight<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value Gets or sets user preference indicating intent of async commit mode.
     */
    @JvmName("vfyjskdwpobjrldn")
    public suspend fun asyncCommitModeIntent(`value`: Either<String, AsyncCommitModeIntent>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asyncCommitModeIntent = mapped
    }

    /**
     * @param value Gets or sets user preference indicating intent of async commit mode.
     */
    @JvmName("vpuqigctalyiwgcw")
    public fun asyncCommitModeIntent(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AsyncCommitModeIntent>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.asyncCommitModeIntent = mapped
    }

    /**
     * @param value Gets or sets user preference indicating intent of async commit mode.
     */
    @JvmName("wovrofxihxpcxvsa")
    public fun asyncCommitModeIntent(`value`: AsyncCommitModeIntent) {
        val toBeMapped = Either.ofRight<String, AsyncCommitModeIntent>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.asyncCommitModeIntent = mapped
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("twxciqqbqatnmovp")
    public suspend fun azureLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("mtnnsdnefrsdvfls")
    public suspend fun azureOfferCode(`value`: Either<String, AzureOfferCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("cpvfnxylrcrurbdr")
    public fun azureOfferCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("wevlgvjbloldqisc")
    public fun azureOfferCode(`value`: AzureOfferCode) {
        val toBeMapped = Either.ofRight<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Gets or sets Azure Offer Code for VM.
     */
    @JvmName("ykohjgblugdweivf")
    public suspend fun azureOfferCodeForVm(`value`: Either<String, AzureOfferCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureOfferCodeForVm = mapped
    }

    /**
     * @param value Gets or sets Azure Offer Code for VM.
     */
    @JvmName("pjwthbpemcogblvm")
    public fun azureOfferCodeForVm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCodeForVm = mapped
    }

    /**
     * @param value Gets or sets Azure Offer Code for VM.
     */
    @JvmName("tlwaafyypkfjdrym")
    public fun azureOfferCodeForVm(`value`: AzureOfferCode) {
        val toBeMapped = Either.ofRight<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCodeForVm = mapped
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("rfhqdoxwetinimvv")
    public suspend fun azureSecurityOfferingType(`value`: Either<String, AzureSecurityOfferingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSecurityOfferingType = mapped
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("iaeumdqiwyieoyui")
    public fun azureSecurityOfferingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSecurityOfferingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSecurityOfferingType = mapped
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("psjgcejlafdaugyl")
    public fun azureSecurityOfferingType(`value`: AzureSecurityOfferingType) {
        val toBeMapped = Either.ofRight<String, AzureSecurityOfferingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSecurityOfferingType = mapped
    }

    /**
     * @param value Gets or sets user configurable SQL database settings.
     */
    @JvmName("kempkeqnumktdcuo")
    public suspend fun azureSqlDatabaseSettings(`value`: SqlDbSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlDatabaseSettings = mapped
    }

    /**
     * @param argument Gets or sets user configurable SQL database settings.
     */
    @JvmName("fyxfualcngqowxes")
    public suspend fun azureSqlDatabaseSettings(argument: suspend SqlDbSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlDbSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureSqlDatabaseSettings = mapped
    }

    /**
     * @param value Gets or sets user configurable SQL managed instance settings.
     */
    @JvmName("jouilprvvvykvgci")
    public suspend fun azureSqlManagedInstanceSettings(`value`: SqlMiSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlManagedInstanceSettings = mapped
    }

    /**
     * @param argument Gets or sets user configurable SQL managed instance settings.
     */
    @JvmName("pvpornmfmgbeaqwq")
    public suspend fun azureSqlManagedInstanceSettings(argument: suspend SqlMiSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlMiSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureSqlManagedInstanceSettings = mapped
    }

    /**
     * @param value Gets or sets user configurable SQL VM settings.
     */
    @JvmName("ydtrnhkinyquwpde")
    public suspend fun azureSqlVmSettings(`value`: SqlVmSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlVmSettings = mapped
    }

    /**
     * @param argument Gets or sets user configurable SQL VM settings.
     */
    @JvmName("gtvlyecclowboamb")
    public suspend fun azureSqlVmSettings(argument: suspend SqlVmSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlVmSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureSqlVmSettings = mapped
    }

    /**
     * @param value Confidence Rating in Percentage.
     */
    @JvmName("phyuxlwwjncncqjf")
    public suspend fun confidenceRatingInPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidenceRatingInPercentage = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("pvvvursoyhitildt")
    public suspend fun currency(`value`: Either<String, AzureCurrency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("iyfovcewwextvsnf")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("xgldqaqvirfewmbt")
    public fun currency(`value`: AzureCurrency) {
        val toBeMapped = Either.ofRight<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Gets or sets the Azure Location or Azure region where to which the machines
     * will be migrated.
     */
    @JvmName("tpfyqsotughposfj")
    public suspend fun disasterRecoveryLocation(`value`: Either<String, AzureLocation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disasterRecoveryLocation = mapped
    }

    /**
     * @param value Gets or sets the Azure Location or Azure region where to which the machines
     * will be migrated.
     */
    @JvmName("uhlmyjndbulrqgss")
    public fun disasterRecoveryLocation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disasterRecoveryLocation = mapped
    }

    /**
     * @param value Gets or sets the Azure Location or Azure region where to which the machines
     * will be migrated.
     */
    @JvmName("fgopoaxaikqsjnyd")
    public fun disasterRecoveryLocation(`value`: AzureLocation) {
        val toBeMapped = Either.ofRight<String, AzureLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disasterRecoveryLocation = mapped
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("ioskhplibfhgexrc")
    public suspend fun discountPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Gets or sets the Enterprise agreement subscription id.
     */
    @JvmName("bblsuhnmirnjnndy")
    public suspend fun eaSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eaSubscriptionId = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether HADR assessments needs to be created.
     */
    @JvmName("pnurjnvkxdgogpvi")
    public suspend fun enableHadrAssessment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHadrAssessment = mapped
    }

    /**
     * @param value Gets or sets the duration for which the entity (SQL, VMs) are up in the
     * on-premises environment.
     */
    @JvmName("qxeiytvtoaqnelwr")
    public suspend fun entityUptime(`value`: EntityUptimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityUptime = mapped
    }

    /**
     * @param argument Gets or sets the duration for which the entity (SQL, VMs) are up in the
     * on-premises environment.
     */
    @JvmName("xwvtdkphfnqoxhvd")
    public suspend fun entityUptime(argument: suspend EntityUptimeArgsBuilder.() -> Unit) {
        val toBeMapped = EntityUptimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.entityUptime = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("roxjpfdeyjvvkmhv")
    public suspend fun environmentType(`value`: Either<String, EnvironmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("xymkhknkddrhwwiy")
    public fun environmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("euvsltymmbmhkffd")
    public fun environmentType(`value`: EnvironmentType) {
        val toBeMapped = Either.ofRight<String, EnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("ypvrlhhnihociaxu")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("kisihkcblajinnwc")
    public suspend fun groupType(`value`: Either<String, GroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("ikvdcfkvpghtixlc")
    public fun groupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("hanelhpcgjtpqjkp")
    public fun groupType(`value`: GroupType) {
        val toBeMapped = Either.ofRight<String, GroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether internet access is available.
     */
    @JvmName("tbifflhebtwcliyk")
    public suspend fun isInternetAccessAvailable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isInternetAccessAvailable = mapped
    }

    /**
     * @param value Gets or sets user preference indicating intent of multi-subnet configuration.
     */
    @JvmName("ctqihhabikgrkqbp")
    public suspend fun multiSubnetIntent(`value`: Either<String, MultiSubnetIntent>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiSubnetIntent = mapped
    }

    /**
     * @param value Gets or sets user preference indicating intent of multi-subnet configuration.
     */
    @JvmName("wdfpsdlmmucirdok")
    public fun multiSubnetIntent(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MultiSubnetIntent>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiSubnetIntent = mapped
    }

    /**
     * @param value Gets or sets user preference indicating intent of multi-subnet configuration.
     */
    @JvmName("tcednomojssvbsyy")
    public fun multiSubnetIntent(`value`: MultiSubnetIntent) {
        val toBeMapped = Either.ofRight<String, MultiSubnetIntent>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiSubnetIntent = mapped
    }

    /**
     * @param value Gets or sets SQL optimization logic.
     */
    @JvmName("smasjksksqyrtjme")
    public suspend fun optimizationLogic(`value`: Either<String, OptimizationLogic>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizationLogic = mapped
    }

    /**
     * @param value Gets or sets SQL optimization logic.
     */
    @JvmName("ybrpaljixwkoprbs")
    public fun optimizationLogic(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OptimizationLogic>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizationLogic = mapped
    }

    /**
     * @param value Gets or sets SQL optimization logic.
     */
    @JvmName("xmwqbvmisbdhyvdk")
    public fun optimizationLogic(`value`: OptimizationLogic) {
        val toBeMapped = Either.ofRight<String, OptimizationLogic>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizationLogic = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the azure hybrid use benefit.
     */
    @JvmName("qeawdghafgojvkgb")
    public suspend fun osLicense(`value`: Either<String, OsLicense>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osLicense = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the azure hybrid use benefit.
     */
    @JvmName("tvhckthwgamsasop")
    public fun osLicense(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsLicense>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osLicense = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the azure hybrid use benefit.
     */
    @JvmName("svajxgtdgrnlavww")
    public fun osLicense(`value`: OsLicense) {
        val toBeMapped = Either.ofRight<String, OsLicense>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osLicense = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("dghtmrirwaiminyj")
    public suspend fun percentile(`value`: Either<String, Percentile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("lgjgxxuqkotmsufe")
    public fun percentile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("fopchkdrasjvliyo")
    public fun percentile(`value`: Percentile) {
        val toBeMapped = Either.ofRight<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("bmsjghaxfgirwacg")
    public suspend fun perfDataEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataEndTime = mapped
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("kmugcyublpdchfjx")
    public suspend fun perfDataStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataStartTime = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("kwjunddqxqdgelxr")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("opgnvfcmctqiasyo")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ibmeyqbbasrcfjnu")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("utbftcxjkcvifvxa")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("gduxjxmmactlcnny")
    public suspend fun reservedInstance(`value`: Either<String, AzureReservedInstance>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("pgjnfapadsnhwdsy")
    public fun reservedInstance(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("scsesoommkvdektv")
    public fun reservedInstance(`value`: AzureReservedInstance) {
        val toBeMapped = Either.ofRight<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Gets or sets azure reserved instance for VM.
     */
    @JvmName("xunpedlvnjibpjso")
    public suspend fun reservedInstanceForVm(`value`: Either<String, AzureReservedInstance>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedInstanceForVm = mapped
    }

    /**
     * @param value Gets or sets azure reserved instance for VM.
     */
    @JvmName("otbklafrgfrcuisg")
    public fun reservedInstanceForVm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstanceForVm = mapped
    }

    /**
     * @param value Gets or sets azure reserved instance for VM.
     */
    @JvmName("hovpkdumxefwxriv")
    public fun reservedInstanceForVm(`value`: AzureReservedInstance) {
        val toBeMapped = Either.ofRight<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstanceForVm = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wewwwxqwddkbvyxj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("mmlwdseorovryhsk")
    public suspend fun scalingFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingFactor = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("sddvbbanchptwmva")
    public suspend fun sizingCriterion(`value`: Either<String, AssessmentSizingCriterion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("mcukcanrqdfferba")
    public fun sizingCriterion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("yfgvrjpuhohjauyx")
    public fun sizingCriterion(`value`: AssessmentSizingCriterion) {
        val toBeMapped = Either.ofRight<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value SQL server license.
     */
    @JvmName("xraqycmxtnbojtsk")
    public suspend fun sqlServerLicense(`value`: Either<String, SqlServerLicense>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerLicense = mapped
    }

    /**
     * @param value SQL server license.
     */
    @JvmName("nqmbwjmkcfbfsplb")
    public fun sqlServerLicense(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlServerLicense>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicense = mapped
    }

    /**
     * @param value SQL server license.
     */
    @JvmName("dekmnjjtnpikouas")
    public fun sqlServerLicense(`value`: SqlServerLicense) {
        val toBeMapped = Either.ofRight<String, SqlServerLicense>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicense = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("tkeydbyiyptiutgl")
    public suspend fun timeRange(`value`: Either<String, TimeRange>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("vteftbbaxfqwffxh")
    public fun timeRange(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("jtuuigcbytygassh")
    public fun timeRange(`value`: TimeRange) {
        val toBeMapped = Either.ofRight<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    internal fun build(): SqlAssessmentV2OperationArgs = SqlAssessmentV2OperationArgs(
        assessmentName = assessmentName,
        assessmentType = assessmentType,
        asyncCommitModeIntent = asyncCommitModeIntent,
        azureLocation = azureLocation,
        azureOfferCode = azureOfferCode,
        azureOfferCodeForVm = azureOfferCodeForVm,
        azureSecurityOfferingType = azureSecurityOfferingType,
        azureSqlDatabaseSettings = azureSqlDatabaseSettings,
        azureSqlManagedInstanceSettings = azureSqlManagedInstanceSettings,
        azureSqlVmSettings = azureSqlVmSettings,
        confidenceRatingInPercentage = confidenceRatingInPercentage,
        currency = currency,
        disasterRecoveryLocation = disasterRecoveryLocation,
        discountPercentage = discountPercentage,
        eaSubscriptionId = eaSubscriptionId,
        enableHadrAssessment = enableHadrAssessment,
        entityUptime = entityUptime,
        environmentType = environmentType,
        groupName = groupName,
        groupType = groupType,
        isInternetAccessAvailable = isInternetAccessAvailable,
        multiSubnetIntent = multiSubnetIntent,
        optimizationLogic = optimizationLogic,
        osLicense = osLicense,
        percentile = percentile,
        perfDataEndTime = perfDataEndTime,
        perfDataStartTime = perfDataStartTime,
        projectName = projectName,
        provisioningState = provisioningState,
        reservedInstance = reservedInstance,
        reservedInstanceForVm = reservedInstanceForVm,
        resourceGroupName = resourceGroupName,
        scalingFactor = scalingFactor,
        sizingCriterion = sizingCriterion,
        sqlServerLicense = sqlServerLicense,
        timeRange = timeRange,
    )
}
