@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.VmwareCollectorsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * VMware collector resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### VmwareCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmwareCollectorsOperation = new AzureNative.Migrate.VmwareCollectorsOperation("vmwareCollectorsOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "fe243486-3318-41fa-aaba-c48b5df75308",
 *             LastHeartbeatUtc = "2022-03-29T12:10:08.9167289Z",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "82b3e452-c0e8-4662-8347-58282925ae84",
 *                 Audience = "82b3e452-c0e8-4662-8347-58282925ae84",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "3fc89111-1405-4938-9214-37aa4739401d",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *             Version = "1.0.8.383",
 *         },
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/VMwareSites/Vmware2744site",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ResourceGroupName = "ayagrawRG",
 *         VmWareCollectorName = "Vmware2258collector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewVmwareCollectorsOperation(ctx, "vmwareCollectorsOperation", &migrate.VmwareCollectorsOperationArgs{
 * 			AgentProperties: &migrate.CollectorAgentPropertiesBaseArgs{
 * 				Id:               pulumi.String("fe243486-3318-41fa-aaba-c48b5df75308"),
 * 				LastHeartbeatUtc: pulumi.String("2022-03-29T12:10:08.9167289Z"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("82b3e452-c0e8-4662-8347-58282925ae84"),
 * 					Audience:      pulumi.String("82b3e452-c0e8-4662-8347-58282925ae84"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("3fc89111-1405-4938-9214-37aa4739401d"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 				Version: pulumi.String("1.0.8.383"),
 * 			},
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/VMwareSites/Vmware2744site"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 			VmWareCollectorName: pulumi.String("Vmware2258collector"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.VmwareCollectorsOperation;
 * import com.pulumi.azurenative.migrate.VmwareCollectorsOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmwareCollectorsOperation = new VmwareCollectorsOperation("vmwareCollectorsOperation", VmwareCollectorsOperationArgs.builder()
 *             .agentProperties(CollectorAgentPropertiesBaseArgs.builder()
 *                 .id("fe243486-3318-41fa-aaba-c48b5df75308")
 *                 .lastHeartbeatUtc("2022-03-29T12:10:08.9167289Z")
 *                 .spnDetails(CollectorAgentSpnPropertiesBaseArgs.builder()
 *                     .applicationId("82b3e452-c0e8-4662-8347-58282925ae84")
 *                     .audience("82b3e452-c0e8-4662-8347-58282925ae84")
 *                     .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .objectId("3fc89111-1405-4938-9214-37aa4739401d")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .version("1.0.8.383")
 *                 .build())
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/VMwareSites/Vmware2744site")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .vmWareCollectorName("Vmware2258collector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:VmwareCollectorsOperation Vmware2258collector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}
 * ```
 * @property agentProperties Gets or sets the collector agent properties.
 * @property discoverySiteId Gets the discovery site id.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vmWareCollectorName VMware collector ARM name
 */
public data class VmwareCollectorsOperationArgs(
    public val agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vmWareCollectorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.VmwareCollectorsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.VmwareCollectorsOperationArgs =
        com.pulumi.azurenative.migrate.VmwareCollectorsOperationArgs.builder()
            .agentProperties(agentProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vmWareCollectorName(vmWareCollectorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmwareCollectorsOperationArgs].
 */
@PulumiTagMarker
public class VmwareCollectorsOperationArgsBuilder internal constructor() {
    private var agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null

    private var discoverySiteId: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var vmWareCollectorName: Output<String>? = null

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("jryyeulnllyoeafh")
    public suspend fun agentProperties(`value`: Output<CollectorAgentPropertiesBaseArgs>) {
        this.agentProperties = value
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("mwhxhqbjdtxhcmth")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("wyjytaxvickxebpj")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("kpystonvivigjvfo")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("arlrskjwcxpetnyp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value VMware collector ARM name
     */
    @JvmName("irvcsnpkvbumeevp")
    public suspend fun vmWareCollectorName(`value`: Output<String>) {
        this.vmWareCollectorName = value
    }

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("ejydkvytojqowpwi")
    public suspend fun agentProperties(`value`: CollectorAgentPropertiesBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProperties = mapped
    }

    /**
     * @param argument Gets or sets the collector agent properties.
     */
    @JvmName("dwnvubplqehmrqjk")
    public suspend fun agentProperties(argument: suspend CollectorAgentPropertiesBaseArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentPropertiesBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentProperties = mapped
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("yeottsevaypeavmi")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("qnbcvsjkgtommxtc")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("rbpaefuchrxacjil")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("pnsofsunumocyfrp")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("xqxexwfnwgaegknb")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggcuylmucmpqufkb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value VMware collector ARM name
     */
    @JvmName("vajrmkphipcqmrri")
    public suspend fun vmWareCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmWareCollectorName = mapped
    }

    internal fun build(): VmwareCollectorsOperationArgs = VmwareCollectorsOperationArgs(
        agentProperties = agentProperties,
        discoverySiteId = discoverySiteId,
        projectName = projectName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        vmWareCollectorName = vmWareCollectorName,
    )
}
