@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.WebAppAssessmentV2OperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentSizingCriterion
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureCurrency
import com.pulumi.azurenative.migrate.kotlin.enums.AzureOfferCode
import com.pulumi.azurenative.migrate.kotlin.enums.AzureReservedInstance
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSecurityOfferingType
import com.pulumi.azurenative.migrate.kotlin.enums.EnvironmentType
import com.pulumi.azurenative.migrate.kotlin.enums.GroupType
import com.pulumi.azurenative.migrate.kotlin.enums.Percentile
import com.pulumi.azurenative.migrate.kotlin.enums.TimeRange
import com.pulumi.azurenative.migrate.kotlin.inputs.AppSvcContainerSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AppSvcContainerSettingsArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.AppSvcNativeSettingsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AppSvcNativeSettingsArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.DiscoveredEntityLightSummaryArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.DiscoveredEntityLightSummaryArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.EntityUptimeArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.EntityUptimeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Web app Assessment REST resource.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### WebAppAssessmentV2Operations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppAssessmentV2Operation = new AzureNative.Migrate.WebAppAssessmentV2Operation("webAppAssessmentV2Operation", new()
 *     {
 *         AppSvcContainerSettings = new AzureNative.Migrate.Inputs.AppSvcContainerSettingsArgs
 *         {
 *             IsolationRequired = true,
 *         },
 *         AppSvcNativeSettings = new AzureNative.Migrate.Inputs.AppSvcNativeSettingsArgs
 *         {
 *             IsolationRequired = true,
 *         },
 *         AssessmentName = "anraghun-selfhost-v2",
 *         AssessmentType = AzureNative.Migrate.AssessmentType.WebAppAssessment,
 *         AzureLocation = "UkWest",
 *         AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Msazr0003P,
 *         AzureSecurityOfferingType = AzureNative.Migrate.AzureSecurityOfferingType.NO,
 *         ConfidenceRatingInPercentage = 13,
 *         Currency = AzureNative.Migrate.AzureCurrency.USD,
 *         DiscountPercentage = 13,
 *         DiscoveredEntityLightSummary = new AzureNative.Migrate.Inputs.DiscoveredEntityLightSummaryArgs
 *         {
 *             NumberOfMachines = 27,
 *             NumberOfServers = 5,
 *             NumberOfWebApps = 23,
 *         },
 *         EaSubscriptionId = "",
 *         EntityUptime = new AzureNative.Migrate.Inputs.EntityUptimeArgs
 *         {
 *             DaysPerMonth = 18,
 *             HoursPerDay = 13,
 *         },
 *         EnvironmentType = AzureNative.Migrate.EnvironmentType.Production,
 *         GroupName = "anraghun-selfhost-v2",
 *         GroupType = AzureNative.Migrate.GroupType.Default,
 *         Percentile = AzureNative.Migrate.Percentile.Percentile50,
 *         PerfDataEndTime = "2023-11-03T05:42:45.496Z",
 *         PerfDataStartTime = "2023-11-03T05:42:45.496Z",
 *         ProjectName = "sumukk-ccy-bcs4557project",
 *         ReservedInstance = AzureNative.Migrate.AzureReservedInstance.None,
 *         ResourceGroupName = "rgopenapi",
 *         ScalingFactor = 17,
 *         SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *         TimeRange = AzureNative.Migrate.TimeRange.Day,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWebAppAssessmentV2Operation(ctx, "webAppAssessmentV2Operation", &migrate.WebAppAssessmentV2OperationArgs{
 * 			AppSvcContainerSettings: &migrate.AppSvcContainerSettingsArgs{
 * 				IsolationRequired: pulumi.Bool(true),
 * 			},
 * 			AppSvcNativeSettings: &migrate.AppSvcNativeSettingsArgs{
 * 				IsolationRequired: pulumi.Bool(true),
 * 			},
 * 			AssessmentName:               pulumi.String("anraghun-selfhost-v2"),
 * 			AssessmentType:               pulumi.String(migrate.AssessmentTypeWebAppAssessment),
 * 			AzureLocation:                pulumi.String("UkWest"),
 * 			AzureOfferCode:               pulumi.String(migrate.AzureOfferCodeMsazr0003P),
 * 			AzureSecurityOfferingType:    pulumi.String(migrate.AzureSecurityOfferingTypeNO),
 * 			ConfidenceRatingInPercentage: pulumi.Float64(13),
 * 			Currency:                     pulumi.String(migrate.AzureCurrencyUSD),
 * 			DiscountPercentage:           pulumi.Float64(13),
 * 			DiscoveredEntityLightSummary: &migrate.DiscoveredEntityLightSummaryArgs{
 * 				NumberOfMachines: pulumi.Int(27),
 * 				NumberOfServers:  pulumi.Int(5),
 * 				NumberOfWebApps:  pulumi.Int(23),
 * 			},
 * 			EaSubscriptionId: pulumi.String(""),
 * 			EntityUptime: &migrate.EntityUptimeArgs{
 * 				DaysPerMonth: pulumi.Int(18),
 * 				HoursPerDay:  pulumi.Int(13),
 * 			},
 * 			EnvironmentType:   pulumi.String(migrate.EnvironmentTypeProduction),
 * 			GroupName:         pulumi.String("anraghun-selfhost-v2"),
 * 			GroupType:         pulumi.String(migrate.GroupTypeDefault),
 * 			Percentile:        pulumi.String(migrate.PercentilePercentile50),
 * 			PerfDataEndTime:   pulumi.String("2023-11-03T05:42:45.496Z"),
 * 			PerfDataStartTime: pulumi.String("2023-11-03T05:42:45.496Z"),
 * 			ProjectName:       pulumi.String("sumukk-ccy-bcs4557project"),
 * 			ReservedInstance:  pulumi.String(migrate.AzureReservedInstanceNone),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			ScalingFactor:     pulumi.Float64(17),
 * 			SizingCriterion:   pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 			TimeRange:         pulumi.String(migrate.TimeRangeDay),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WebAppAssessmentV2Operation;
 * import com.pulumi.azurenative.migrate.WebAppAssessmentV2OperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.AppSvcContainerSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.AppSvcNativeSettingsArgs;
 * import com.pulumi.azurenative.migrate.inputs.DiscoveredEntityLightSummaryArgs;
 * import com.pulumi.azurenative.migrate.inputs.EntityUptimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppAssessmentV2Operation = new WebAppAssessmentV2Operation("webAppAssessmentV2Operation", WebAppAssessmentV2OperationArgs.builder()
 *             .appSvcContainerSettings(AppSvcContainerSettingsArgs.builder()
 *                 .isolationRequired(true)
 *                 .build())
 *             .appSvcNativeSettings(AppSvcNativeSettingsArgs.builder()
 *                 .isolationRequired(true)
 *                 .build())
 *             .assessmentName("anraghun-selfhost-v2")
 *             .assessmentType("WebAppAssessment")
 *             .azureLocation("UkWest")
 *             .azureOfferCode("MSAZR0003P")
 *             .azureSecurityOfferingType("NO")
 *             .confidenceRatingInPercentage(13)
 *             .currency("USD")
 *             .discountPercentage(13)
 *             .discoveredEntityLightSummary(DiscoveredEntityLightSummaryArgs.builder()
 *                 .numberOfMachines(27)
 *                 .numberOfServers(5)
 *                 .numberOfWebApps(23)
 *                 .build())
 *             .eaSubscriptionId("")
 *             .entityUptime(EntityUptimeArgs.builder()
 *                 .daysPerMonth(18)
 *                 .hoursPerDay(13)
 *                 .build())
 *             .environmentType("Production")
 *             .groupName("anraghun-selfhost-v2")
 *             .groupType("Default")
 *             .percentile("Percentile50")
 *             .perfDataEndTime("2023-11-03T05:42:45.496Z")
 *             .perfDataStartTime("2023-11-03T05:42:45.496Z")
 *             .projectName("sumukk-ccy-bcs4557project")
 *             .reservedInstance("None")
 *             .resourceGroupName("rgopenapi")
 *             .scalingFactor(17)
 *             .sizingCriterion("PerformanceBased")
 *             .timeRange("Day")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WebAppAssessmentV2Operation anraghun-v2-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/webAppAssessments/{assessmentName}
 * ```
 * @property appSvcContainerSettings Gets or sets user configurable app service container database settings.
 * @property appSvcNativeSettings Gets or sets user configurable app service native settings.
 * @property assessmentName Web app Assessment arm name.
 * @property assessmentType Assessment type of the assessment.
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer Code.
 * @property azureSecurityOfferingType Gets or sets a value indicating azure security offering type.
 * @property confidenceRatingInPercentage Confidence Rating in Percentage.
 * @property currency Currency in which prices should be reported.
 * @property discountPercentage Custom discount percentage.
 * @property discoveredEntityLightSummary Gets or sets user configurable discovered entity settings.
 * @property eaSubscriptionId Gets or sets the Enterprise agreement subscription id.
 * @property entityUptime Gets or sets the duration for which the entity (Web app, VMs) are up in the
 * on-premises environment.
 * @property environmentType Gets or sets user configurable setting to display the environment type.
 * @property groupName Group ARM name
 * @property groupType Gets the group type for the assessment.
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property projectName Assessment Project Name
 * @property reservedInstance Reserved instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property sizingCriterion Assessment sizing criterion.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 */
public data class WebAppAssessmentV2OperationArgs(
    public val appSvcContainerSettings: Output<AppSvcContainerSettingsArgs>? = null,
    public val appSvcNativeSettings: Output<AppSvcNativeSettingsArgs>? = null,
    public val assessmentName: Output<String>? = null,
    public val assessmentType: Output<Either<String, AssessmentType>>? = null,
    public val azureLocation: Output<String>? = null,
    public val azureOfferCode: Output<Either<String, AzureOfferCode>>? = null,
    public val azureSecurityOfferingType: Output<Either<String, AzureSecurityOfferingType>>? = null,
    public val confidenceRatingInPercentage: Output<Double>? = null,
    public val currency: Output<Either<String, AzureCurrency>>? = null,
    public val discountPercentage: Output<Double>? = null,
    public val discoveredEntityLightSummary: Output<DiscoveredEntityLightSummaryArgs>? = null,
    public val eaSubscriptionId: Output<String>? = null,
    public val entityUptime: Output<EntityUptimeArgs>? = null,
    public val environmentType: Output<Either<String, EnvironmentType>>? = null,
    public val groupName: Output<String>? = null,
    public val groupType: Output<Either<String, GroupType>>? = null,
    public val percentile: Output<Either<String, Percentile>>? = null,
    public val perfDataEndTime: Output<String>? = null,
    public val perfDataStartTime: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val reservedInstance: Output<Either<String, AzureReservedInstance>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingFactor: Output<Double>? = null,
    public val sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null,
    public val timeRange: Output<Either<String, TimeRange>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.WebAppAssessmentV2OperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.WebAppAssessmentV2OperationArgs =
        com.pulumi.azurenative.migrate.WebAppAssessmentV2OperationArgs.builder()
            .appSvcContainerSettings(
                appSvcContainerSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .appSvcNativeSettings(
                appSvcNativeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .assessmentType(
                assessmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureLocation(azureLocation?.applyValue({ args0 -> args0 }))
            .azureOfferCode(
                azureOfferCode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureSecurityOfferingType(
                azureSecurityOfferingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .confidenceRatingInPercentage(confidenceRatingInPercentage?.applyValue({ args0 -> args0 }))
            .currency(
                currency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .discountPercentage(discountPercentage?.applyValue({ args0 -> args0 }))
            .discoveredEntityLightSummary(
                discoveredEntityLightSummary?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .eaSubscriptionId(eaSubscriptionId?.applyValue({ args0 -> args0 }))
            .entityUptime(entityUptime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentType(
                environmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .groupType(
                groupType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .percentile(
                percentile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .perfDataEndTime(perfDataEndTime?.applyValue({ args0 -> args0 }))
            .perfDataStartTime(perfDataStartTime?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .reservedInstance(
                reservedInstance?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingFactor(scalingFactor?.applyValue({ args0 -> args0 }))
            .sizingCriterion(
                sizingCriterion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeRange(
                timeRange?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAppAssessmentV2OperationArgs].
 */
@PulumiTagMarker
public class WebAppAssessmentV2OperationArgsBuilder internal constructor() {
    private var appSvcContainerSettings: Output<AppSvcContainerSettingsArgs>? = null

    private var appSvcNativeSettings: Output<AppSvcNativeSettingsArgs>? = null

    private var assessmentName: Output<String>? = null

    private var assessmentType: Output<Either<String, AssessmentType>>? = null

    private var azureLocation: Output<String>? = null

    private var azureOfferCode: Output<Either<String, AzureOfferCode>>? = null

    private var azureSecurityOfferingType: Output<Either<String, AzureSecurityOfferingType>>? = null

    private var confidenceRatingInPercentage: Output<Double>? = null

    private var currency: Output<Either<String, AzureCurrency>>? = null

    private var discountPercentage: Output<Double>? = null

    private var discoveredEntityLightSummary: Output<DiscoveredEntityLightSummaryArgs>? = null

    private var eaSubscriptionId: Output<String>? = null

    private var entityUptime: Output<EntityUptimeArgs>? = null

    private var environmentType: Output<Either<String, EnvironmentType>>? = null

    private var groupName: Output<String>? = null

    private var groupType: Output<Either<String, GroupType>>? = null

    private var percentile: Output<Either<String, Percentile>>? = null

    private var perfDataEndTime: Output<String>? = null

    private var perfDataStartTime: Output<String>? = null

    private var projectName: Output<String>? = null

    private var reservedInstance: Output<Either<String, AzureReservedInstance>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingFactor: Output<Double>? = null

    private var sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null

    private var timeRange: Output<Either<String, TimeRange>>? = null

    /**
     * @param value Gets or sets user configurable app service container database settings.
     */
    @JvmName("kencbaqpnatpyjqh")
    public suspend fun appSvcContainerSettings(`value`: Output<AppSvcContainerSettingsArgs>) {
        this.appSvcContainerSettings = value
    }

    /**
     * @param value Gets or sets user configurable app service native settings.
     */
    @JvmName("audjxwdrqvnmcpyj")
    public suspend fun appSvcNativeSettings(`value`: Output<AppSvcNativeSettingsArgs>) {
        this.appSvcNativeSettings = value
    }

    /**
     * @param value Web app Assessment arm name.
     */
    @JvmName("tthcfkcjjbigwolk")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("nvkktlfrpbwawwok")
    public suspend fun assessmentType(`value`: Output<Either<String, AssessmentType>>) {
        this.assessmentType = value
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("ulqasmilxojwkssb")
    public suspend fun azureLocation(`value`: Output<String>) {
        this.azureLocation = value
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("rgsksjkfrptkqdyw")
    public suspend fun azureOfferCode(`value`: Output<Either<String, AzureOfferCode>>) {
        this.azureOfferCode = value
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("ghnrynkysmfnuvwu")
    public suspend fun azureSecurityOfferingType(`value`: Output<Either<String, AzureSecurityOfferingType>>) {
        this.azureSecurityOfferingType = value
    }

    /**
     * @param value Confidence Rating in Percentage.
     */
    @JvmName("ceiveowiuxvbkmfm")
    public suspend fun confidenceRatingInPercentage(`value`: Output<Double>) {
        this.confidenceRatingInPercentage = value
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("puregbxxucheyydj")
    public suspend fun currency(`value`: Output<Either<String, AzureCurrency>>) {
        this.currency = value
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("ujujufnfkmtpqpgv")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Gets or sets user configurable discovered entity settings.
     */
    @JvmName("vwokyvhnulghvdcy")
    public suspend fun discoveredEntityLightSummary(`value`: Output<DiscoveredEntityLightSummaryArgs>) {
        this.discoveredEntityLightSummary = value
    }

    /**
     * @param value Gets or sets the Enterprise agreement subscription id.
     */
    @JvmName("hxhsvnlnnftrbtjr")
    public suspend fun eaSubscriptionId(`value`: Output<String>) {
        this.eaSubscriptionId = value
    }

    /**
     * @param value Gets or sets the duration for which the entity (Web app, VMs) are up in the
     * on-premises environment.
     */
    @JvmName("bthayklxriuwqmdl")
    public suspend fun entityUptime(`value`: Output<EntityUptimeArgs>) {
        this.entityUptime = value
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("kbvfpmnrtfnkupmx")
    public suspend fun environmentType(`value`: Output<Either<String, EnvironmentType>>) {
        this.environmentType = value
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("luwvngooyyyscaow")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("wmadfrlodhvkfvag")
    public suspend fun groupType(`value`: Output<Either<String, GroupType>>) {
        this.groupType = value
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("fcinlsennqicjxrg")
    public suspend fun percentile(`value`: Output<Either<String, Percentile>>) {
        this.percentile = value
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("tsiljxdvasgrfiou")
    public suspend fun perfDataEndTime(`value`: Output<String>) {
        this.perfDataEndTime = value
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("fmpffmsbltasnarb")
    public suspend fun perfDataStartTime(`value`: Output<String>) {
        this.perfDataStartTime = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ksbjerylpmwmawhp")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("efvngnjfqxsplhlo")
    public suspend fun reservedInstance(`value`: Output<Either<String, AzureReservedInstance>>) {
        this.reservedInstance = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vllqskqsraksakur")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("fcfwkvgfgrrhqknv")
    public suspend fun scalingFactor(`value`: Output<Double>) {
        this.scalingFactor = value
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("nwxiywlajsrnsmmq")
    public suspend fun sizingCriterion(`value`: Output<Either<String, AssessmentSizingCriterion>>) {
        this.sizingCriterion = value
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("xwxvuhimapeibfea")
    public suspend fun timeRange(`value`: Output<Either<String, TimeRange>>) {
        this.timeRange = value
    }

    /**
     * @param value Gets or sets user configurable app service container database settings.
     */
    @JvmName("ldxwwgwajpaymhnl")
    public suspend fun appSvcContainerSettings(`value`: AppSvcContainerSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSvcContainerSettings = mapped
    }

    /**
     * @param argument Gets or sets user configurable app service container database settings.
     */
    @JvmName("asitpbgcthufonlc")
    public suspend fun appSvcContainerSettings(argument: suspend AppSvcContainerSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AppSvcContainerSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.appSvcContainerSettings = mapped
    }

    /**
     * @param value Gets or sets user configurable app service native settings.
     */
    @JvmName("boifofcropspahkg")
    public suspend fun appSvcNativeSettings(`value`: AppSvcNativeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSvcNativeSettings = mapped
    }

    /**
     * @param argument Gets or sets user configurable app service native settings.
     */
    @JvmName("cuywnccjenvdjbik")
    public suspend fun appSvcNativeSettings(argument: suspend AppSvcNativeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AppSvcNativeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.appSvcNativeSettings = mapped
    }

    /**
     * @param value Web app Assessment arm name.
     */
    @JvmName("actvnguhxegjuofo")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("wexxmtkrrtrohxmx")
    public suspend fun assessmentType(`value`: Either<String, AssessmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("ixxnfpiiugrpluep")
    public fun assessmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value Assessment type of the assessment.
     */
    @JvmName("ijychuooahykthjx")
    public fun assessmentType(`value`: AssessmentType) {
        val toBeMapped = Either.ofRight<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value Azure Location or Azure region where to which the machines will be migrated.
     */
    @JvmName("adaorttasfjaynhn")
    public suspend fun azureLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("siuccrllwoxomsnq")
    public suspend fun azureOfferCode(`value`: Either<String, AzureOfferCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("idnxgtmnjgjdgkay")
    public fun azureOfferCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Azure Offer Code.
     */
    @JvmName("wntrggfwowlkqxjs")
    public fun azureOfferCode(`value`: AzureOfferCode) {
        val toBeMapped = Either.ofRight<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("exjnngwikctuygnn")
    public suspend fun azureSecurityOfferingType(`value`: Either<String, AzureSecurityOfferingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSecurityOfferingType = mapped
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("felmcikiybsjpaln")
    public fun azureSecurityOfferingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSecurityOfferingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSecurityOfferingType = mapped
    }

    /**
     * @param value Gets or sets a value indicating azure security offering type.
     */
    @JvmName("wuksbnbwfdlbcsnv")
    public fun azureSecurityOfferingType(`value`: AzureSecurityOfferingType) {
        val toBeMapped = Either.ofRight<String, AzureSecurityOfferingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSecurityOfferingType = mapped
    }

    /**
     * @param value Confidence Rating in Percentage.
     */
    @JvmName("vvcecijmfkmhqxqe")
    public suspend fun confidenceRatingInPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidenceRatingInPercentage = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("eaemrtfpurxwowpo")
    public suspend fun currency(`value`: Either<String, AzureCurrency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("gdewsqbaseoltyfh")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency in which prices should be reported.
     */
    @JvmName("rtlggnfaqfhlbsog")
    public fun currency(`value`: AzureCurrency) {
        val toBeMapped = Either.ofRight<String, AzureCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Custom discount percentage.
     */
    @JvmName("hdvfaorwiprvglsx")
    public suspend fun discountPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Gets or sets user configurable discovered entity settings.
     */
    @JvmName("xjpbsgtggaglyaou")
    public suspend fun discoveredEntityLightSummary(`value`: DiscoveredEntityLightSummaryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveredEntityLightSummary = mapped
    }

    /**
     * @param argument Gets or sets user configurable discovered entity settings.
     */
    @JvmName("wqolprshptdjooug")
    public suspend fun discoveredEntityLightSummary(argument: suspend DiscoveredEntityLightSummaryArgsBuilder.() -> Unit) {
        val toBeMapped = DiscoveredEntityLightSummaryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.discoveredEntityLightSummary = mapped
    }

    /**
     * @param value Gets or sets the Enterprise agreement subscription id.
     */
    @JvmName("podafawdhfqsgvfv")
    public suspend fun eaSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eaSubscriptionId = mapped
    }

    /**
     * @param value Gets or sets the duration for which the entity (Web app, VMs) are up in the
     * on-premises environment.
     */
    @JvmName("tprnwdetwdcyxbtk")
    public suspend fun entityUptime(`value`: EntityUptimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityUptime = mapped
    }

    /**
     * @param argument Gets or sets the duration for which the entity (Web app, VMs) are up in the
     * on-premises environment.
     */
    @JvmName("bhivbawjoagixfuc")
    public suspend fun entityUptime(argument: suspend EntityUptimeArgsBuilder.() -> Unit) {
        val toBeMapped = EntityUptimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.entityUptime = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("yjbyfxofejoipjdn")
    public suspend fun environmentType(`value`: Either<String, EnvironmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("fovgqvpvqkrfykrc")
    public fun environmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Gets or sets user configurable setting to display the environment type.
     */
    @JvmName("icghntxowpruhvun")
    public fun environmentType(`value`: EnvironmentType) {
        val toBeMapped = Either.ofRight<String, EnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("umdgljmeqldkkvia")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("pobymsymkwwlvrpr")
    public suspend fun groupType(`value`: Either<String, GroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("jxqxludodhgsnvok")
    public fun groupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Gets the group type for the assessment.
     */
    @JvmName("vnvkxjdikmqranrw")
    public fun groupType(`value`: GroupType) {
        val toBeMapped = Either.ofRight<String, GroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("oadljlvjyenxufwk")
    public suspend fun percentile(`value`: Either<String, Percentile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("jvmsobnmacftnwvt")
    public fun percentile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    @JvmName("khjbgfjqhamxegva")
    public fun percentile(`value`: Percentile) {
        val toBeMapped = Either.ofRight<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets or sets the end time to consider performance data for assessment.
     */
    @JvmName("ybpsgvslnlexkdxn")
    public suspend fun perfDataEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataEndTime = mapped
    }

    /**
     * @param value Gets or sets the start time to consider performance data for assessment.
     */
    @JvmName("kaeivqmwgwdkstdr")
    public suspend fun perfDataStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataStartTime = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("jsoabpeffiwkssfo")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("xklsaoxmxkibsyqm")
    public suspend fun reservedInstance(`value`: Either<String, AzureReservedInstance>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("gordhiggmnwuspfd")
    public fun reservedInstance(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Reserved instance.
     */
    @JvmName("bebjidlrejfppskf")
    public fun reservedInstance(`value`: AzureReservedInstance) {
        val toBeMapped = Either.ofRight<String, AzureReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qindydclxmordaws")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    @JvmName("wxkjgygfbmikuycj")
    public suspend fun scalingFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingFactor = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("jyxxudkyqborujuu")
    public suspend fun sizingCriterion(`value`: Either<String, AssessmentSizingCriterion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("aflqjgttakvuuyol")
    public fun sizingCriterion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("lyjbxhpbqejnfjnq")
    public fun sizingCriterion(`value`: AssessmentSizingCriterion) {
        val toBeMapped = Either.ofRight<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("xfdbiyvnebwukgto")
    public suspend fun timeRange(`value`: Either<String, TimeRange>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("tjkpwmrlcxsovlsc")
    public fun timeRange(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    @JvmName("tdwwtibgjmgdcmus")
    public fun timeRange(`value`: TimeRange) {
        val toBeMapped = Either.ofRight<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    internal fun build(): WebAppAssessmentV2OperationArgs = WebAppAssessmentV2OperationArgs(
        appSvcContainerSettings = appSvcContainerSettings,
        appSvcNativeSettings = appSvcNativeSettings,
        assessmentName = assessmentName,
        assessmentType = assessmentType,
        azureLocation = azureLocation,
        azureOfferCode = azureOfferCode,
        azureSecurityOfferingType = azureSecurityOfferingType,
        confidenceRatingInPercentage = confidenceRatingInPercentage,
        currency = currency,
        discountPercentage = discountPercentage,
        discoveredEntityLightSummary = discoveredEntityLightSummary,
        eaSubscriptionId = eaSubscriptionId,
        entityUptime = entityUptime,
        environmentType = environmentType,
        groupName = groupName,
        groupType = groupType,
        percentile = percentile,
        perfDataEndTime = perfDataEndTime,
        perfDataStartTime = perfDataStartTime,
        projectName = projectName,
        reservedInstance = reservedInstance,
        resourceGroupName = resourceGroupName,
        scalingFactor = scalingFactor,
        sizingCriterion = sizingCriterion,
        timeRange = timeRange,
    )
}
