@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse.Companion.toKotlin as collectorAgentPropertiesBaseResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WebAppCollectorOperation].
 */
@PulumiTagMarker
public class WebAppCollectorOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppCollectorOperationArgs = WebAppCollectorOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppCollectorOperationArgsBuilder.() -> Unit) {
        val builder = WebAppCollectorOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppCollectorOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.WebAppCollectorOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppCollectorOperation(builtJavaResource)
    }
}

/**
 * The web app collector REST object.
 * Azure REST API version: 2023-04-01-preview.
 * ## Example Usage
 * ### WebAppCollectorOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppCollectorOperation = new AzureNative.Migrate.WebAppCollectorOperation("webAppCollectorOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "fed93df5-b787-4e3f-a764-e3d2b9101a59-agent",
 *             LastHeartbeatUtc = "2023-11-03T05:43:02.078Z",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *                 Audience = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *                 Authority = "https://login.microsoftonline.com/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *                 TenantId = "2f70d5e8-7adc-4c64-910a-7031079efc6e",
 *             },
 *         },
 *         CollectorName = "collector1",
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sumukk-ccy-bcs/providers/Microsoft.OffAzure/MasterSites/sumukk-ccy-bcs9880mastersite/WebAppSites/sumukk-ccy-bcs9880webappsites",
 *         ProjectName = "sumukk-ccy-bcs4557project",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWebAppCollectorOperation(ctx, "webAppCollectorOperation", &migrate.WebAppCollectorOperationArgs{
 * 			AgentProperties: &migrate.CollectorAgentPropertiesBaseArgs{
 * 				Id:               pulumi.String("fed93df5-b787-4e3f-a764-e3d2b9101a59-agent"),
 * 				LastHeartbeatUtc: pulumi.String("2023-11-03T05:43:02.078Z"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 					Audience:      pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 					Authority:     pulumi.String("https://login.microsoftonline.com/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 					TenantId:      pulumi.String("2f70d5e8-7adc-4c64-910a-7031079efc6e"),
 * 				},
 * 			},
 * 			CollectorName:     pulumi.String("collector1"),
 * 			DiscoverySiteId:   pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sumukk-ccy-bcs/providers/Microsoft.OffAzure/MasterSites/sumukk-ccy-bcs9880mastersite/WebAppSites/sumukk-ccy-bcs9880webappsites"),
 * 			ProjectName:       pulumi.String("sumukk-ccy-bcs4557project"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WebAppCollectorOperation;
 * import com.pulumi.azurenative.migrate.WebAppCollectorOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentSpnPropertiesBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppCollectorOperation = new WebAppCollectorOperation("webAppCollectorOperation", WebAppCollectorOperationArgs.builder()
 *             .agentProperties(CollectorAgentPropertiesBaseArgs.builder()
 *                 .id("fed93df5-b787-4e3f-a764-e3d2b9101a59-agent")
 *                 .lastHeartbeatUtc("2023-11-03T05:43:02.078Z")
 *                 .spnDetails(CollectorAgentSpnPropertiesBaseArgs.builder()
 *                     .applicationId("2f70d5e8-7adc-4c64-910a-7031079efc6e")
 *                     .audience("2f70d5e8-7adc-4c64-910a-7031079efc6e")
 *                     .authority("https://login.microsoftonline.com/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .objectId("2f70d5e8-7adc-4c64-910a-7031079efc6e")
 *                     .tenantId("2f70d5e8-7adc-4c64-910a-7031079efc6e")
 *                     .build())
 *                 .build())
 *             .collectorName("collector1")
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sumukk-ccy-bcs/providers/Microsoft.OffAzure/MasterSites/sumukk-ccy-bcs9880mastersite/WebAppSites/sumukk-ccy-bcs9880webappsites")
 *             .projectName("sumukk-ccy-bcs4557project")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WebAppCollectorOperation sumukk-ccy-bcs4a93webappsitecollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/webAppCollectors/{collectorName}
 * ```
 */
public class WebAppCollectorOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.WebAppCollectorOperation,
) : KotlinCustomResource(javaResource, WebAppCollectorOperationMapper) {
    /**
     * Gets or sets the collector agent properties.
     */
    public val agentProperties: Output<CollectorAgentPropertiesBaseResponse>?
        get() = javaResource.agentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> collectorAgentPropertiesBaseResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the Timestamp when collector was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the discovery site id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Timestamp when collector was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object WebAppCollectorOperationMapper : ResourceMapper<WebAppCollectorOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.WebAppCollectorOperation::class == javaResource::class

    override fun map(javaResource: Resource): WebAppCollectorOperation =
        WebAppCollectorOperation(
            javaResource as
                com.pulumi.azurenative.migrate.WebAppCollectorOperation,
        )
}

/**
 * @see [WebAppCollectorOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppCollectorOperation].
 */
public suspend fun webAppCollectorOperation(
    name: String,
    block: suspend WebAppCollectorOperationResourceBuilder.() -> Unit,
): WebAppCollectorOperation {
    val builder = WebAppCollectorOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppCollectorOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppCollectorOperation(name: String): WebAppCollectorOperation {
    val builder = WebAppCollectorOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
