@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelPropertiesResponse.Companion.toKotlin as workloadDeploymentModelPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelResponseSystemData.Companion.toKotlin as workloadDeploymentModelResponseSystemDataToKotlin

/**
 * Builder for [WorkloadDeployment].
 */
@PulumiTagMarker
public class WorkloadDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadDeploymentArgs = WorkloadDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadDeploymentArgsBuilder.() -> Unit) {
        val builder = WorkloadDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadDeployment {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.WorkloadDeployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadDeployment(builtJavaResource)
    }
}

/**
 * Workload deployment model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### WorkloadDeployment_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadDeployment = new AzureNative.Migrate.WorkloadDeployment("workloadDeployment", new()
 *     {
 *         ModernizeProjectName = "l6r8",
 *         Properties = new AzureNative.Migrate.Inputs.WorkloadDeploymentModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "IISAKSWorkloadDeployment" },
 *             },
 *             DisplayName = "wqe",
 *             TargetPlatform = AzureNative.Migrate.WorkloadDeploymentTarget.AzureKubernetesService,
 *             WorkloadInstanceProperties = new AzureNative.Migrate.Inputs.WorkloadInstanceModelPropertiesArgs
 *             {
 *                 CustomProperties =
 *                 {
 *                     { "instanceType", "IISWorkload" },
 *                     { "webAppArmId", "xseseqsrzdiga" },
 *                     { "webAppSiteName", "mirgzmy" },
 *                 },
 *                 DisplayName = "juoorbubchvk",
 *                 MasterSiteName = "ubks",
 *                 MigrateAgentId = "aqgzsxqbk",
 *                 Name = "wonkuhgsafzviuwqerzdmme",
 *                 SourceName = "weuxcqzwpeyzsjhdgqflhxlwjhbz",
 *                 SourcePlatform = "eh",
 *             },
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key8241", "gcyxztzr" },
 *         },
 *         WorkloadDeploymentName = "l4t",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewWorkloadDeployment(ctx, "workloadDeployment", &migrate.WorkloadDeploymentArgs{
 * ModernizeProjectName: pulumi.String("l6r8"),
 * Properties: &migrate.WorkloadDeploymentModelPropertiesArgs{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("IISAKSWorkloadDeployment"),
 * },
 * DisplayName: pulumi.String("wqe"),
 * TargetPlatform: pulumi.String(migrate.WorkloadDeploymentTargetAzureKubernetesService),
 * WorkloadInstanceProperties: &migrate.WorkloadInstanceModelPropertiesArgs{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("IISWorkload"),
 * WebAppArmId: pulumi.String("xseseqsrzdiga"),
 * WebAppSiteName: pulumi.String("mirgzmy"),
 * },
 * DisplayName: pulumi.String("juoorbubchvk"),
 * MasterSiteName: pulumi.String("ubks"),
 * MigrateAgentId: pulumi.String("aqgzsxqbk"),
 * Name: pulumi.String("wonkuhgsafzviuwqerzdmme"),
 * SourceName: pulumi.String("weuxcqzwpeyzsjhdgqflhxlwjhbz"),
 * SourcePlatform: pulumi.String("eh"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * Tags: pulumi.StringMap{
 * "key8241": pulumi.String("gcyxztzr"),
 * },
 * WorkloadDeploymentName: pulumi.String("l4t"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadDeployment;
 * import com.pulumi.azurenative.migrate.WorkloadDeploymentArgs;
 * import com.pulumi.azurenative.migrate.inputs.WorkloadDeploymentModelPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.WorkloadInstanceModelPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadDeployment = new WorkloadDeployment("workloadDeployment", WorkloadDeploymentArgs.builder()
 *             .modernizeProjectName("l6r8")
 *             .properties(WorkloadDeploymentModelPropertiesArgs.builder()
 *                 .customProperties(IISAKSWorkloadDeploymentModelCustomPropertiesArgs.builder()
 *                     .instanceType("IISAKSWorkloadDeployment")
 *                     .build())
 *                 .displayName("wqe")
 *                 .targetPlatform("AzureKubernetesService")
 *                 .workloadInstanceProperties(WorkloadInstanceModelPropertiesArgs.builder()
 *                     .customProperties(IISWorkloadInstanceModelCustomPropertiesArgs.builder()
 *                         .instanceType("IISWorkload")
 *                         .webAppArmId("xseseqsrzdiga")
 *                         .webAppSiteName("mirgzmy")
 *                         .build())
 *                     .displayName("juoorbubchvk")
 *                     .masterSiteName("ubks")
 *                     .migrateAgentId("aqgzsxqbk")
 *                     .name("wonkuhgsafzviuwqerzdmme")
 *                     .sourceName("weuxcqzwpeyzsjhdgqflhxlwjhbz")
 *                     .sourcePlatform("eh")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key8241", "gcyxztzr"))
 *             .workloadDeploymentName("l4t")
 *             .build());
 *     }
 * }
 * ```
 * ### WorkloadDeployment_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadDeployment = new AzureNative.Migrate.WorkloadDeployment("workloadDeployment", new()
 *     {
 *         ModernizeProjectName = "tc",
 *         ResourceGroupName = "rgmigrateEngine",
 *         WorkloadDeploymentName = "wo2rs4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWorkloadDeployment(ctx, "workloadDeployment", &migrate.WorkloadDeploymentArgs{
 * 			ModernizeProjectName:   pulumi.String("tc"),
 * 			ResourceGroupName:      pulumi.String("rgmigrateEngine"),
 * 			WorkloadDeploymentName: pulumi.String("wo2rs4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadDeployment;
 * import com.pulumi.azurenative.migrate.WorkloadDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadDeployment = new WorkloadDeployment("workloadDeployment", WorkloadDeploymentArgs.builder()
 *             .modernizeProjectName("tc")
 *             .resourceGroupName("rgmigrateEngine")
 *             .workloadDeploymentName("wo2rs4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WorkloadDeployment obqwiueoajtezyusejl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}/workloadDeployments/{workloadDeploymentName}
 * ```
 */
public class WorkloadDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.WorkloadDeployment,
) : KotlinCustomResource(javaResource, WorkloadDeploymentMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Workload deployment model properties.
     */
    public val properties: Output<WorkloadDeploymentModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                workloadDeploymentModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<WorkloadDeploymentModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                workloadDeploymentModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadDeploymentMapper : ResourceMapper<WorkloadDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.WorkloadDeployment::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadDeployment = WorkloadDeployment(
        javaResource as
            com.pulumi.azurenative.migrate.WorkloadDeployment,
    )
}

/**
 * @see [WorkloadDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadDeployment].
 */
public suspend fun workloadDeployment(
    name: String,
    block: suspend WorkloadDeploymentResourceBuilder.() -> Unit,
): WorkloadDeployment {
    val builder = WorkloadDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadDeployment(name: String): WorkloadDeployment {
    val builder = WorkloadDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
