@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadInstanceModelPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadInstanceModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadInstanceModelPropertiesResponse.Companion.toKotlin as workloadInstanceModelPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadInstanceModelResponseSystemData.Companion.toKotlin as workloadInstanceModelResponseSystemDataToKotlin

/**
 * Builder for [WorkloadInstance].
 */
@PulumiTagMarker
public class WorkloadInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadInstanceArgs = WorkloadInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadInstanceArgsBuilder.() -> Unit) {
        val builder = WorkloadInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadInstance {
        val builtJavaResource = com.pulumi.azurenative.migrate.WorkloadInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkloadInstance(builtJavaResource)
    }
}

/**
 * Workload instance model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### WorkloadInstance_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadInstance = new AzureNative.Migrate.WorkloadInstance("workloadInstance", new()
 *     {
 *         ModernizeProjectName = "mx8",
 *         Properties = new AzureNative.Migrate.Inputs.WorkloadInstanceModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "IISWorkload" },
 *                 { "webAppArmId", "xseseqsrzdiga" },
 *                 { "webAppSiteName", "mirgzmy" },
 *             },
 *             DisplayName = "juoorbubchvk",
 *             MasterSiteName = "ubks",
 *             MigrateAgentId = "aqgzsxqbk",
 *             Name = "wonkuhgsafzviuwqerzdmme",
 *             SourceName = "weuxcqzwpeyzsjhdgqflhxlwjhbz",
 *             SourcePlatform = "eh",
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key2836", "biqip" },
 *         },
 *         WorkloadInstanceName = "m",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewWorkloadInstance(ctx, "workloadInstance", &migrate.WorkloadInstanceArgs{
 * ModernizeProjectName: pulumi.String("mx8"),
 * Properties: &migrate.WorkloadInstanceModelPropertiesArgs{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("IISWorkload"),
 * WebAppArmId: pulumi.String("xseseqsrzdiga"),
 * WebAppSiteName: pulumi.String("mirgzmy"),
 * },
 * DisplayName: pulumi.String("juoorbubchvk"),
 * MasterSiteName: pulumi.String("ubks"),
 * MigrateAgentId: pulumi.String("aqgzsxqbk"),
 * Name: pulumi.String("wonkuhgsafzviuwqerzdmme"),
 * SourceName: pulumi.String("weuxcqzwpeyzsjhdgqflhxlwjhbz"),
 * SourcePlatform: pulumi.String("eh"),
 * },
 * ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * Tags: pulumi.StringMap{
 * "key2836": pulumi.String("biqip"),
 * },
 * WorkloadInstanceName: pulumi.String("m"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadInstance;
 * import com.pulumi.azurenative.migrate.WorkloadInstanceArgs;
 * import com.pulumi.azurenative.migrate.inputs.WorkloadInstanceModelPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadInstance = new WorkloadInstance("workloadInstance", WorkloadInstanceArgs.builder()
 *             .modernizeProjectName("mx8")
 *             .properties(WorkloadInstanceModelPropertiesArgs.builder()
 *                 .customProperties(IISWorkloadInstanceModelCustomPropertiesArgs.builder()
 *                     .instanceType("IISWorkload")
 *                     .webAppArmId("xseseqsrzdiga")
 *                     .webAppSiteName("mirgzmy")
 *                     .build())
 *                 .displayName("juoorbubchvk")
 *                 .masterSiteName("ubks")
 *                 .migrateAgentId("aqgzsxqbk")
 *                 .name("wonkuhgsafzviuwqerzdmme")
 *                 .sourceName("weuxcqzwpeyzsjhdgqflhxlwjhbz")
 *                 .sourcePlatform("eh")
 *                 .build())
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key2836", "biqip"))
 *             .workloadInstanceName("m")
 *             .build());
 *     }
 * }
 * ```
 * ### WorkloadInstance_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadInstance = new AzureNative.Migrate.WorkloadInstance("workloadInstance", new()
 *     {
 *         ModernizeProjectName = "tv39",
 *         ResourceGroupName = "rgmigrateEngine",
 *         WorkloadInstanceName = "io",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWorkloadInstance(ctx, "workloadInstance", &migrate.WorkloadInstanceArgs{
 * 			ModernizeProjectName: pulumi.String("tv39"),
 * 			ResourceGroupName:    pulumi.String("rgmigrateEngine"),
 * 			WorkloadInstanceName: pulumi.String("io"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadInstance;
 * import com.pulumi.azurenative.migrate.WorkloadInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadInstance = new WorkloadInstance("workloadInstance", WorkloadInstanceArgs.builder()
 *             .modernizeProjectName("tv39")
 *             .resourceGroupName("rgmigrateEngine")
 *             .workloadInstanceName("io")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WorkloadInstance piu /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}/workloadInstances/{workloadInstanceName}
 * ```
 */
public class WorkloadInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.WorkloadInstance,
) : KotlinCustomResource(javaResource, WorkloadInstanceMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Workload instance model properties.
     */
    public val properties: Output<WorkloadInstanceModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                workloadInstanceModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<WorkloadInstanceModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                workloadInstanceModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadInstanceMapper : ResourceMapper<WorkloadInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.WorkloadInstance::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadInstance = WorkloadInstance(
        javaResource as
            com.pulumi.azurenative.migrate.WorkloadInstance,
    )
}

/**
 * @see [WorkloadInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadInstance].
 */
public suspend fun workloadInstance(
    name: String,
    block: suspend WorkloadInstanceResourceBuilder.() -> Unit,
): WorkloadInstance {
    val builder = WorkloadInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadInstance(name: String): WorkloadInstance {
    val builder = WorkloadInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
