@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Assessment sizing criterion.
 */
public enum class AssessmentSizingCriterion(
    public val javaValue: com.pulumi.azurenative.migrate.enums.AssessmentSizingCriterion,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.AssessmentSizingCriterion> {
    /**
     * Performance Data based Sizing.
     */
    PerformanceBased(com.pulumi.azurenative.migrate.enums.AssessmentSizingCriterion.PerformanceBased),

    /**
     * As On Premises or Static Data based Sizing.
     */
    AsOnPremises(com.pulumi.azurenative.migrate.enums.AssessmentSizingCriterion.AsOnPremises),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.AssessmentSizingCriterion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.AssessmentSizingCriterion): AssessmentSizingCriterion =
            AssessmentSizingCriterion.values().first { it.javaValue == javaType }
    }
}
