@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * User configurable setting that describes the status of the assessment.
 */
public enum class AssessmentStage(
    public val javaValue: com.pulumi.azurenative.migrate.enums.AssessmentStage,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.AssessmentStage> {
    InProgress(com.pulumi.azurenative.migrate.enums.AssessmentStage.InProgress),
    UnderReview(com.pulumi.azurenative.migrate.enums.AssessmentStage.UnderReview),
    Approved(com.pulumi.azurenative.migrate.enums.AssessmentStage.Approved),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.AssessmentStage = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.AssessmentStage): AssessmentStage = AssessmentStage.values().first { it.javaValue == javaType }
    }
}
