@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Assessment type of the assessment.
 */
public enum class AssessmentType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.AssessmentType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.AssessmentType> {
    Unknown(com.pulumi.azurenative.migrate.enums.AssessmentType.Unknown),
    MachineAssessment(com.pulumi.azurenative.migrate.enums.AssessmentType.MachineAssessment),
    AvsAssessment(com.pulumi.azurenative.migrate.enums.AssessmentType.AvsAssessment),
    SqlAssessment(com.pulumi.azurenative.migrate.enums.AssessmentType.SqlAssessment),
    WebAppAssessment(com.pulumi.azurenative.migrate.enums.AssessmentType.WebAppAssessment),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.AssessmentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.AssessmentType): AssessmentType = AssessmentType.values().first { it.javaValue == javaType }
    }
}
