@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the configuration type.
 */
public enum class ConfigurationType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.ConfigurationType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.ConfigurationType> {
    IISConnectionString(com.pulumi.azurenative.migrate.enums.ConfigurationType.IISConnectionString),
    IISAuthentication(com.pulumi.azurenative.migrate.enums.ConfigurationType.IISAuthentication),
    ApacheTomcatContextResource(com.pulumi.azurenative.migrate.enums.ConfigurationType.ApacheTomcatContextResource),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.ConfigurationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.ConfigurationType): ConfigurationType = ConfigurationType.values().first { it.javaValue == javaType }
    }
}
