@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Workload discovery source.
 */
public enum class DiscoverySource(
    public val javaValue: com.pulumi.azurenative.migrate.enums.DiscoverySource,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.DiscoverySource> {
    /**
     * Unknown Discovery Source.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.DiscoverySource.Unknown),

    /**
     * Appliance Discovery Source.
     */
    Appliance(com.pulumi.azurenative.migrate.enums.DiscoverySource.Appliance),

    /**
     * Import Discovery Source.
     */
    Import(com.pulumi.azurenative.migrate.enums.DiscoverySource.Import),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.DiscoverySource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.DiscoverySource): DiscoverySource = DiscoverySource.values().first { it.javaValue == javaType }
    }
}
