@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets the group type for the assessment.
 */
public enum class GroupType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.GroupType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.GroupType> {
    Default(com.pulumi.azurenative.migrate.enums.GroupType.Default),
    Import(com.pulumi.azurenative.migrate.enums.GroupType.Import),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.GroupType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.GroupType): GroupType =
            GroupType.values().first { it.javaValue == javaType }
    }
}
