@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * HyperV licence type.
 */
public enum class HyperVLicenseType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.HyperVLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.HyperVLicenseType> {
    /**
     * Unknown HyperV License.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.HyperVLicenseType.Unknown),

    /**
     * Datacentre HyperV License.
     */
    Datacentre(com.pulumi.azurenative.migrate.enums.HyperVLicenseType.Datacentre),

    /**
     * Standard HyperV License.
     */
    Standard(com.pulumi.azurenative.migrate.enums.HyperVLicenseType.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.HyperVLicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.HyperVLicenseType): HyperVLicenseType = HyperVLicenseType.values().first { it.javaValue == javaType }
    }
}
