@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Migration Strategy.
 */
public enum class MigrationStrategy(
    public val javaValue: com.pulumi.azurenative.migrate.enums.MigrationStrategy,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.MigrationStrategy> {
    /**
     * Unknown Migration Strategy.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.MigrationStrategy.Unknown),

    /**
     * Optimize for cost.
     */
    OptimizeForCost(com.pulumi.azurenative.migrate.enums.MigrationStrategy.OptimizeForCost),

    /**
     * IaaS only.
     */
    IaaSOnly(com.pulumi.azurenative.migrate.enums.MigrationStrategy.IaaSOnly),

    /**
     * Optimize for PaaS.
     */
    OptimizeForPaas(com.pulumi.azurenative.migrate.enums.MigrationStrategy.OptimizeForPaas),

    /**
     * Avs only.
     */
    AVSOnly(com.pulumi.azurenative.migrate.enums.MigrationStrategy.AVSOnly),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.MigrationStrategy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.MigrationStrategy): MigrationStrategy = MigrationStrategy.values().first { it.javaValue == javaType }
    }
}
