@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets user preference indicating intent of multi-subnet configuration.
 */
public enum class MultiSubnetIntent(
    public val javaValue: com.pulumi.azurenative.migrate.enums.MultiSubnetIntent,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.MultiSubnetIntent> {
    None(com.pulumi.azurenative.migrate.enums.MultiSubnetIntent.None),
    HighAvailability(com.pulumi.azurenative.migrate.enums.MultiSubnetIntent.HighAvailability),
    DisasterRecovery(com.pulumi.azurenative.migrate.enums.MultiSubnetIntent.DisasterRecovery),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.MultiSubnetIntent = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.MultiSubnetIntent): MultiSubnetIntent = MultiSubnetIntent.values().first { it.javaValue == javaType }
    }
}
