@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets SQL optimization logic.
 */
public enum class OptimizationLogic(
    public val javaValue: com.pulumi.azurenative.migrate.enums.OptimizationLogic,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.OptimizationLogic> {
    MinimizeCost(com.pulumi.azurenative.migrate.enums.OptimizationLogic.MinimizeCost),
    ModernizeToPaaS(com.pulumi.azurenative.migrate.enums.OptimizationLogic.ModernizeToPaaS),
    ModernizeToAzureSqlMi(com.pulumi.azurenative.migrate.enums.OptimizationLogic.ModernizeToAzureSqlMi),
    ModernizeToAzureSqlDb(com.pulumi.azurenative.migrate.enums.OptimizationLogic.ModernizeToAzureSqlDb),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.OptimizationLogic = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.OptimizationLogic): OptimizationLogic = OptimizationLogic.values().first { it.javaValue == javaType }
    }
}
