@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Azure reserved instance.
 */
public enum class ReservedInstance(
    public val javaValue: com.pulumi.azurenative.migrate.enums.ReservedInstance,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.ReservedInstance> {
    None(com.pulumi.azurenative.migrate.enums.ReservedInstance.None),
    RI1Year(com.pulumi.azurenative.migrate.enums.ReservedInstance.RI1Year),
    RI3Year(com.pulumi.azurenative.migrate.enums.ReservedInstance.RI3Year),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.ReservedInstance = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.ReservedInstance): ReservedInstance = ReservedInstance.values().first { it.javaValue == javaType }
    }
}
