@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets the business case savings option type.
 */
public enum class SavingsOption(
    public val javaValue: com.pulumi.azurenative.migrate.enums.SavingsOption,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.SavingsOption> {
    /**
     * Unknown Savings Option.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.SavingsOption.Unknown),

    /**
     * Reserved Instance 3 Year.
     */
    RI3Year(com.pulumi.azurenative.migrate.enums.SavingsOption.RI3Year),

    /**
     * Azure Savings Plan 3 Year.
     */
    SavingsPlan3Year(com.pulumi.azurenative.migrate.enums.SavingsOption.SavingsPlan3Year),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.SavingsOption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.SavingsOption): SavingsOption = SavingsOption.values().first { it.javaValue == javaType }
    }
}
