@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets savings options.
 */
public enum class SavingsOptions(
    public val javaValue: com.pulumi.azurenative.migrate.enums.SavingsOptions,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.SavingsOptions> {
    /**
     * Savings Options is not applicable.
     */
    None(com.pulumi.azurenative.migrate.enums.SavingsOptions.None),

    /**
     * One Year Savings Plan.
     */
    OneYearSavings(com.pulumi.azurenative.migrate.enums.SavingsOptions.OneYearSavings),

    /**
     * Three Years Savings Plan.
     */
    ThreeYearsSavings(com.pulumi.azurenative.migrate.enums.SavingsOptions.ThreeYearsSavings),

    /**
     * One Year Reserved Instances.
     */
    OneYearReserved(com.pulumi.azurenative.migrate.enums.SavingsOptions.OneYearReserved),

    /**
     * Three Years Reserved Instances.
     */
    ThreeYearsReserved(com.pulumi.azurenative.migrate.enums.SavingsOptions.ThreeYearsReserved),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.SavingsOptions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.SavingsOptions): SavingsOptions = SavingsOptions.values().first { it.javaValue == javaType }
    }
}
