@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * SQL Server version.
 */
public enum class SqlServerLicenseType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.SqlServerLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.SqlServerLicenseType> {
    /**
     * Unknown Sql Server License.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.SqlServerLicenseType.Unknown),

    /**
     * Enterprise Sql Server License.
     */
    Enterprise(com.pulumi.azurenative.migrate.enums.SqlServerLicenseType.Enterprise),

    /**
     * Standard Sql Server License.
     */
    Standard(com.pulumi.azurenative.migrate.enums.SqlServerLicenseType.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.SqlServerLicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.SqlServerLicenseType): SqlServerLicenseType = SqlServerLicenseType.values().first { it.javaValue == javaType }
    }
}
