@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Time Range for which the historic utilization data should be considered for
 * assessment.
 */
public enum class TimeRange(
    public val javaValue: com.pulumi.azurenative.migrate.enums.TimeRange,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.TimeRange> {
    /**
     * Daily.
     */
    Day(com.pulumi.azurenative.migrate.enums.TimeRange.Day),

    /**
     * Weekly.
     */
    Week(com.pulumi.azurenative.migrate.enums.TimeRange.Week),

    /**
     * Monthly.
     */
    Month(com.pulumi.azurenative.migrate.enums.TimeRange.Month),

    /**
     * Custom Time Range.
     */
    Custom(com.pulumi.azurenative.migrate.enums.TimeRange.Custom),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.TimeRange = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.TimeRange): TimeRange =
            TimeRange.values().first { it.javaValue == javaType }
    }
}
