@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ApacheTomcat web application.
 * @property applicationId Gets or sets the web application id.
 * @property applicationName Gets or sets the web application name.
 * @property applicationScratchPath Gets or sets application scratch path.
 * @property bindings Gets or sets the bindings for the application.
 * @property configurations Gets or sets application configuration.
 * @property directories Gets or sets application directories.
 * @property discoveredFrameworks Gets or sets the discovered frameworks of application.
 * @property displayName Gets or sets the display name.
 * @property limits Resource Requirements.
 * @property path Second level entity for virtual directories.
 * @property primaryFramework Framework specific data for a web application.
 * @property requests Resource Requirements.
 * @property webServerId Gets or sets the web server id.
 * @property webServerName Gets or sets the web server name.
 */
public data class ApacheTomcatWebApplicationArgs(
    public val applicationId: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val applicationScratchPath: Output<String>? = null,
    public val bindings: Output<List<BindingArgs>>? = null,
    public val configurations: Output<List<WebApplicationConfigurationArgs>>? = null,
    public val directories: Output<List<WebApplicationDirectoryArgs>>? = null,
    public val discoveredFrameworks: Output<List<WebApplicationFrameworkArgs>>? = null,
    public val displayName: Output<String>? = null,
    public val limits: Output<ResourceRequirementsArgs>? = null,
    public val path: Output<DirectoryPathArgs>? = null,
    public val primaryFramework: Output<WebApplicationFrameworkArgs>? = null,
    public val requests: Output<ResourceRequirementsArgs>? = null,
    public val webServerId: Output<String>? = null,
    public val webServerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs =
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatWebApplicationArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .applicationScratchPath(applicationScratchPath?.applyValue({ args0 -> args0 }))
            .bindings(
                bindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .directories(
                directories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .discoveredFrameworks(
                discoveredFrameworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryFramework(primaryFramework?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requests(requests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webServerId(webServerId?.applyValue({ args0 -> args0 }))
            .webServerName(webServerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApacheTomcatWebApplicationArgs].
 */
@PulumiTagMarker
public class ApacheTomcatWebApplicationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var applicationScratchPath: Output<String>? = null

    private var bindings: Output<List<BindingArgs>>? = null

    private var configurations: Output<List<WebApplicationConfigurationArgs>>? = null

    private var directories: Output<List<WebApplicationDirectoryArgs>>? = null

    private var discoveredFrameworks: Output<List<WebApplicationFrameworkArgs>>? = null

    private var displayName: Output<String>? = null

    private var limits: Output<ResourceRequirementsArgs>? = null

    private var path: Output<DirectoryPathArgs>? = null

    private var primaryFramework: Output<WebApplicationFrameworkArgs>? = null

    private var requests: Output<ResourceRequirementsArgs>? = null

    private var webServerId: Output<String>? = null

    private var webServerName: Output<String>? = null

    /**
     * @param value Gets or sets the web application id.
     */
    @JvmName("eyhfrcglvcojhfaf")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Gets or sets the web application name.
     */
    @JvmName("canwfcolvpelykxc")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Gets or sets application scratch path.
     */
    @JvmName("aertpoqebxafcows")
    public suspend fun applicationScratchPath(`value`: Output<String>) {
        this.applicationScratchPath = value
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("jvauxhxkfgsjjvif")
    public suspend fun bindings(`value`: Output<List<BindingArgs>>) {
        this.bindings = value
    }

    @JvmName("ungvvmfwvjuaemxh")
    public suspend fun bindings(vararg values: Output<BindingArgs>) {
        this.bindings = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("vjckavlorerigwst")
    public suspend fun bindings(values: List<Output<BindingArgs>>) {
        this.bindings = Output.all(values)
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("odgwhskevukheewr")
    public suspend fun configurations(`value`: Output<List<WebApplicationConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("gysodbaqdnvhojcn")
    public suspend fun configurations(vararg values: Output<WebApplicationConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("qvfnxgbskushbidy")
    public suspend fun configurations(values: List<Output<WebApplicationConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("krxkpeuohytqvmtt")
    public suspend fun directories(`value`: Output<List<WebApplicationDirectoryArgs>>) {
        this.directories = value
    }

    @JvmName("bbpwrwfvdumaglcf")
    public suspend fun directories(vararg values: Output<WebApplicationDirectoryArgs>) {
        this.directories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("pkbqpxmopptsrykt")
    public suspend fun directories(values: List<Output<WebApplicationDirectoryArgs>>) {
        this.directories = Output.all(values)
    }

    /**
     * @param value Gets or sets the discovered frameworks of application.
     */
    @JvmName("qnppcywpkausgehy")
    public suspend fun discoveredFrameworks(`value`: Output<List<WebApplicationFrameworkArgs>>) {
        this.discoveredFrameworks = value
    }

    @JvmName("nmutgrmosikcpmnv")
    public suspend fun discoveredFrameworks(vararg values: Output<WebApplicationFrameworkArgs>) {
        this.discoveredFrameworks = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the discovered frameworks of application.
     */
    @JvmName("ryntdqpsnvqnvteh")
    public suspend fun discoveredFrameworks(values: List<Output<WebApplicationFrameworkArgs>>) {
        this.discoveredFrameworks = Output.all(values)
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("eahdqjptdbpslpwm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("dlwjgvmlteukjeyh")
    public suspend fun limits(`value`: Output<ResourceRequirementsArgs>) {
        this.limits = value
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("apcjwdqqqofnguqr")
    public suspend fun path(`value`: Output<DirectoryPathArgs>) {
        this.path = value
    }

    /**
     * @param value Framework specific data for a web application.
     */
    @JvmName("ndplsdbgqsrhitbc")
    public suspend fun primaryFramework(`value`: Output<WebApplicationFrameworkArgs>) {
        this.primaryFramework = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("huaomqikyhohwovs")
    public suspend fun requests(`value`: Output<ResourceRequirementsArgs>) {
        this.requests = value
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("gvjcdnvyugreoruk")
    public suspend fun webServerId(`value`: Output<String>) {
        this.webServerId = value
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("frpekfipkibbrlit")
    public suspend fun webServerName(`value`: Output<String>) {
        this.webServerName = value
    }

    /**
     * @param value Gets or sets the web application id.
     */
    @JvmName("cjtautodnstwgdoq")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Gets or sets the web application name.
     */
    @JvmName("jsaeavandubejwry")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Gets or sets application scratch path.
     */
    @JvmName("xeqcjnqrfadmmdgx")
    public suspend fun applicationScratchPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationScratchPath = mapped
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("eawdnushxipgwpdj")
    public suspend fun bindings(`value`: List<BindingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("fwprwtanqgrqjdhu")
    public suspend fun bindings(argument: List<suspend BindingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("csipyyxaipjpmdxv")
    public suspend fun bindings(vararg argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("omrdpwldpobixnpk")
    public suspend fun bindings(argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BindingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("btpljumwojrhfdvu")
    public suspend fun bindings(vararg values: BindingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("yjpjcxsunvtlvdvc")
    public suspend fun configurations(`value`: List<WebApplicationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("qnhavpwnrnhckyfr")
    public suspend fun configurations(argument: List<suspend WebApplicationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("taqjsmlbjlyjrare")
    public suspend fun configurations(vararg argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("rmuninldqrwkjwdq")
    public suspend fun configurations(argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("kisrdujkiawqoimk")
    public suspend fun configurations(vararg values: WebApplicationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("krpmtgkjgcpknewm")
    public suspend fun directories(`value`: List<WebApplicationDirectoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("egiwnyxpxfwjdfds")
    public suspend fun directories(argument: List<suspend WebApplicationDirectoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("riccplkeaevknhni")
    public suspend fun directories(vararg argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("hnrxvyghfqjapqop")
    public suspend fun directories(argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationDirectoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("wlomcifdnmbtjmvs")
    public suspend fun directories(vararg values: WebApplicationDirectoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param value Gets or sets the discovered frameworks of application.
     */
    @JvmName("nqgwndvxvjaqsaba")
    public suspend fun discoveredFrameworks(`value`: List<WebApplicationFrameworkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("xiyrhbpajlumpjnd")
    public suspend fun discoveredFrameworks(argument: List<suspend WebApplicationFrameworkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationFrameworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("rpnclvussnsllvbp")
    public suspend fun discoveredFrameworks(vararg argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebApplicationFrameworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param argument Gets or sets the discovered frameworks of application.
     */
    @JvmName("dafabcfvqtlfqgcj")
    public suspend fun discoveredFrameworks(argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationFrameworkArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.discoveredFrameworks = mapped
    }

    /**
     * @param values Gets or sets the discovered frameworks of application.
     */
    @JvmName("aodsxicqmnfmgrna")
    public suspend fun discoveredFrameworks(vararg values: WebApplicationFrameworkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveredFrameworks = mapped
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("yulcdugkiltwafhn")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("paojrjeqrmadrcfc")
    public suspend fun limits(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("qlerwiwomicrtajt")
    public suspend fun limits(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("yiygrtyhgdaycags")
    public suspend fun path(`value`: DirectoryPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Second level entity for virtual directories.
     */
    @JvmName("achhyahtdeafuing")
    public suspend fun path(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value Framework specific data for a web application.
     */
    @JvmName("bdhnunqqldvpbels")
    public suspend fun primaryFramework(`value`: WebApplicationFrameworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFramework = mapped
    }

    /**
     * @param argument Framework specific data for a web application.
     */
    @JvmName("ujrvodeiqrlkdhtg")
    public suspend fun primaryFramework(argument: suspend WebApplicationFrameworkArgsBuilder.() -> Unit) {
        val toBeMapped = WebApplicationFrameworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryFramework = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("mvmqpbekmdnlocpg")
    public suspend fun requests(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("lxjerwspdxswcpgb")
    public suspend fun requests(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("dvadcgqgbtjgxrbh")
    public suspend fun webServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerId = mapped
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("vwkguvlkvlbnwswk")
    public suspend fun webServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerName = mapped
    }

    internal fun build(): ApacheTomcatWebApplicationArgs = ApacheTomcatWebApplicationArgs(
        applicationId = applicationId,
        applicationName = applicationName,
        applicationScratchPath = applicationScratchPath,
        bindings = bindings,
        configurations = configurations,
        directories = directories,
        discoveredFrameworks = discoveredFrameworks,
        displayName = displayName,
        limits = limits,
        path = path,
        primaryFramework = primaryFramework,
        requests = requests,
        webServerId = webServerId,
        webServerName = webServerName,
    )
}
