@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AppSvcContainerSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * App service container settings.
 * @property isolationRequired Gets or sets the isolation required.
 */
public data class AppSvcContainerSettingsArgs(
    public val isolationRequired: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AppSvcContainerSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AppSvcContainerSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.AppSvcContainerSettingsArgs.builder()
            .isolationRequired(isolationRequired.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppSvcContainerSettingsArgs].
 */
@PulumiTagMarker
public class AppSvcContainerSettingsArgsBuilder internal constructor() {
    private var isolationRequired: Output<Boolean>? = null

    /**
     * @param value Gets or sets the isolation required.
     */
    @JvmName("uwxdtfvbwhxpykdy")
    public suspend fun isolationRequired(`value`: Output<Boolean>) {
        this.isolationRequired = value
    }

    /**
     * @param value Gets or sets the isolation required.
     */
    @JvmName("jlqlutappxqpntlg")
    public suspend fun isolationRequired(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isolationRequired = mapped
    }

    internal fun build(): AppSvcContainerSettingsArgs = AppSvcContainerSettingsArgs(
        isolationRequired = isolationRequired ?: throw PulumiNullFieldException("isolationRequired"),
    )
}
