@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AutomationArtifactArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AutomationArtifactStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Class for automation artifact.
 * @property artifacts Gets or sets the artifacts.
 * @property azureFileShareProfile Azure file share profile for hydration of application folders not mounted on
 * the container file system.
 * @property status Gets or sets the status of automation artifacts.
 */
public data class AutomationArtifactArgs(
    public val artifacts: Output<Map<String, String>>? = null,
    public val azureFileShareProfile: Output<AzureFileShareHydrationProfileArgs>? = null,
    public val status: Output<Either<String, AutomationArtifactStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AutomationArtifactArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AutomationArtifactArgs =
        com.pulumi.azurenative.migrate.inputs.AutomationArtifactArgs.builder()
            .artifacts(
                artifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .azureFileShareProfile(
                azureFileShareProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationArtifactArgs].
 */
@PulumiTagMarker
public class AutomationArtifactArgsBuilder internal constructor() {
    private var artifacts: Output<Map<String, String>>? = null

    private var azureFileShareProfile: Output<AzureFileShareHydrationProfileArgs>? = null

    private var status: Output<Either<String, AutomationArtifactStatus>>? = null

    /**
     * @param value Gets or sets the artifacts.
     */
    @JvmName("glbiashcosuhdyjr")
    public suspend fun artifacts(`value`: Output<Map<String, String>>) {
        this.artifacts = value
    }

    /**
     * @param value Azure file share profile for hydration of application folders not mounted on
     * the container file system.
     */
    @JvmName("oenypyoarstclvmc")
    public suspend fun azureFileShareProfile(`value`: Output<AzureFileShareHydrationProfileArgs>) {
        this.azureFileShareProfile = value
    }

    /**
     * @param value Gets or sets the status of automation artifacts.
     */
    @JvmName("biauadvqyppnpyhu")
    public suspend fun status(`value`: Output<Either<String, AutomationArtifactStatus>>) {
        this.status = value
    }

    /**
     * @param value Gets or sets the artifacts.
     */
    @JvmName("kkyruiyvhlugmtvs")
    public suspend fun artifacts(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param values Gets or sets the artifacts.
     */
    @JvmName("gnopgvrkeffdunqw")
    public fun artifacts(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param value Azure file share profile for hydration of application folders not mounted on
     * the container file system.
     */
    @JvmName("akrcaudgdocifwpv")
    public suspend fun azureFileShareProfile(`value`: AzureFileShareHydrationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareProfile = mapped
    }

    /**
     * @param argument Azure file share profile for hydration of application folders not mounted on
     * the container file system.
     */
    @JvmName("lueabisiayktubqk")
    public suspend fun azureFileShareProfile(argument: suspend AzureFileShareHydrationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileShareHydrationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFileShareProfile = mapped
    }

    /**
     * @param value Gets or sets the status of automation artifacts.
     */
    @JvmName("kjvfaxhmdmvlqnaw")
    public suspend fun status(`value`: Either<String, AutomationArtifactStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the status of automation artifacts.
     */
    @JvmName("owovwgwhuwhoflip")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutomationArtifactStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the status of automation artifacts.
     */
    @JvmName("idxwvmokuwjdlcqy")
    public fun status(`value`: AutomationArtifactStatus) {
        val toBeMapped = Either.ofRight<String, AutomationArtifactStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AutomationArtifactArgs = AutomationArtifactArgs(
        artifacts = artifacts,
        azureFileShareProfile = azureFileShareProfile,
        status = status,
    )
}
