@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AzureFileShareHydrationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure file share profile for hydration of application folders not mounted on
 * the container file system.
 * @property azureFileShareDirPath Gets or sets the cloud directory path of the directory on azure file share.
 * @property azureFileShareName Gets or sets the name of the azure file share.
 * @property azureFileShareResourceGroup Gets or sets the name of the azure file share resource group.
 * @property azureFileShareStorageAccount Gets or sets the name of the azure file share storage account.
 * @property azureFileShareSubscriptionId Gets or sets the subscription id of the azure file share.
 */
public data class AzureFileShareHydrationProfileArgs(
    public val azureFileShareDirPath: Output<String>? = null,
    public val azureFileShareName: Output<String>? = null,
    public val azureFileShareResourceGroup: Output<String>? = null,
    public val azureFileShareStorageAccount: Output<String>? = null,
    public val azureFileShareSubscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AzureFileShareHydrationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AzureFileShareHydrationProfileArgs =
        com.pulumi.azurenative.migrate.inputs.AzureFileShareHydrationProfileArgs.builder()
            .azureFileShareDirPath(azureFileShareDirPath?.applyValue({ args0 -> args0 }))
            .azureFileShareName(azureFileShareName?.applyValue({ args0 -> args0 }))
            .azureFileShareResourceGroup(azureFileShareResourceGroup?.applyValue({ args0 -> args0 }))
            .azureFileShareStorageAccount(azureFileShareStorageAccount?.applyValue({ args0 -> args0 }))
            .azureFileShareSubscriptionId(azureFileShareSubscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileShareHydrationProfileArgs].
 */
@PulumiTagMarker
public class AzureFileShareHydrationProfileArgsBuilder internal constructor() {
    private var azureFileShareDirPath: Output<String>? = null

    private var azureFileShareName: Output<String>? = null

    private var azureFileShareResourceGroup: Output<String>? = null

    private var azureFileShareStorageAccount: Output<String>? = null

    private var azureFileShareSubscriptionId: Output<String>? = null

    /**
     * @param value Gets or sets the cloud directory path of the directory on azure file share.
     */
    @JvmName("mqexlicdttnrxdin")
    public suspend fun azureFileShareDirPath(`value`: Output<String>) {
        this.azureFileShareDirPath = value
    }

    /**
     * @param value Gets or sets the name of the azure file share.
     */
    @JvmName("xyllrjvvvymuckkf")
    public suspend fun azureFileShareName(`value`: Output<String>) {
        this.azureFileShareName = value
    }

    /**
     * @param value Gets or sets the name of the azure file share resource group.
     */
    @JvmName("cfkhvjvqijtijxjq")
    public suspend fun azureFileShareResourceGroup(`value`: Output<String>) {
        this.azureFileShareResourceGroup = value
    }

    /**
     * @param value Gets or sets the name of the azure file share storage account.
     */
    @JvmName("vvpnvvsumdiwcsvy")
    public suspend fun azureFileShareStorageAccount(`value`: Output<String>) {
        this.azureFileShareStorageAccount = value
    }

    /**
     * @param value Gets or sets the subscription id of the azure file share.
     */
    @JvmName("bsxmeonbreefwbtk")
    public suspend fun azureFileShareSubscriptionId(`value`: Output<String>) {
        this.azureFileShareSubscriptionId = value
    }

    /**
     * @param value Gets or sets the cloud directory path of the directory on azure file share.
     */
    @JvmName("jkcylvyksvhinpdv")
    public suspend fun azureFileShareDirPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareDirPath = mapped
    }

    /**
     * @param value Gets or sets the name of the azure file share.
     */
    @JvmName("pmtshbefxeaqvtgk")
    public suspend fun azureFileShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareName = mapped
    }

    /**
     * @param value Gets or sets the name of the azure file share resource group.
     */
    @JvmName("ekexhbqtvxayvdbc")
    public suspend fun azureFileShareResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareResourceGroup = mapped
    }

    /**
     * @param value Gets or sets the name of the azure file share storage account.
     */
    @JvmName("fnbwhsicynxdhgwm")
    public suspend fun azureFileShareStorageAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareStorageAccount = mapped
    }

    /**
     * @param value Gets or sets the subscription id of the azure file share.
     */
    @JvmName("oqsyhyrdwkkpowhq")
    public suspend fun azureFileShareSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareSubscriptionId = mapped
    }

    internal fun build(): AzureFileShareHydrationProfileArgs = AzureFileShareHydrationProfileArgs(
        azureFileShareDirPath = azureFileShareDirPath,
        azureFileShareName = azureFileShareName,
        azureFileShareResourceGroup = azureFileShareResourceGroup,
        azureFileShareStorageAccount = azureFileShareStorageAccount,
        azureFileShareSubscriptionId = azureFileShareSubscriptionId,
    )
}
