@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AzureSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.BusinessCaseCurrency
import com.pulumi.azurenative.migrate.kotlin.enums.DiscoverySource
import com.pulumi.azurenative.migrate.kotlin.enums.MigrationStrategy
import com.pulumi.azurenative.migrate.kotlin.enums.SavingsOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure settings for a business case.
 * @property avsLaborCostPercentage Gets Avs labour cost percentage.
 * @property businessCaseType Migration Strategy.
 * @property comfortFactor Gets comfort factor.
 * @property currency Business case Currency.
 * @property discountPercentage Gets azure Discount percentage.
 * @property iaasLaborCostPercentage Gets IaaS labour cost percentage.
 * @property infrastructureGrowthRate Gets infrastructure growth rate.
 * @property networkCostPercentage Gets network cost percentage.
 * @property paasLaborCostPercentage Gets PaaS labour cost percentage.
 * @property perYearMigrationCompletionPercentage Gets migration completion percentage per year.
 * @property performanceDataEndTime Gets end time to use for performance.
 * @property performanceDataStartTime Gets start time to use for performance.
 * @property performanceUtilizationPercentile Gets utilization percentile for performance.
 * @property savingsOption Gets the business case savings option type.
 * @property targetLocation Gets or sets azure location.
 * @property wacc Gets wACC percentage.
 * @property workloadDiscoverySource Workload discovery source.
 */
public data class AzureSettingsArgs(
    public val avsLaborCostPercentage: Output<Double>? = null,
    public val businessCaseType: Output<Either<String, MigrationStrategy>>? = null,
    public val comfortFactor: Output<Double>? = null,
    public val currency: Output<Either<String, BusinessCaseCurrency>>,
    public val discountPercentage: Output<Double>? = null,
    public val iaasLaborCostPercentage: Output<Double>? = null,
    public val infrastructureGrowthRate: Output<Double>? = null,
    public val networkCostPercentage: Output<Double>? = null,
    public val paasLaborCostPercentage: Output<Double>? = null,
    public val perYearMigrationCompletionPercentage: Output<Map<String, Double>>? = null,
    public val performanceDataEndTime: Output<String>? = null,
    public val performanceDataStartTime: Output<String>? = null,
    public val performanceUtilizationPercentile: Output<Double>? = null,
    public val savingsOption: Output<Either<String, SavingsOption>>? = null,
    public val targetLocation: Output<String>,
    public val wacc: Output<Double>? = null,
    public val workloadDiscoverySource: Output<Either<String, DiscoverySource>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AzureSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AzureSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.AzureSettingsArgs.builder()
            .avsLaborCostPercentage(avsLaborCostPercentage?.applyValue({ args0 -> args0 }))
            .businessCaseType(
                businessCaseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .comfortFactor(comfortFactor?.applyValue({ args0 -> args0 }))
            .currency(
                currency.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .discountPercentage(discountPercentage?.applyValue({ args0 -> args0 }))
            .iaasLaborCostPercentage(iaasLaborCostPercentage?.applyValue({ args0 -> args0 }))
            .infrastructureGrowthRate(infrastructureGrowthRate?.applyValue({ args0 -> args0 }))
            .networkCostPercentage(networkCostPercentage?.applyValue({ args0 -> args0 }))
            .paasLaborCostPercentage(paasLaborCostPercentage?.applyValue({ args0 -> args0 }))
            .perYearMigrationCompletionPercentage(
                perYearMigrationCompletionPercentage?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .performanceDataEndTime(performanceDataEndTime?.applyValue({ args0 -> args0 }))
            .performanceDataStartTime(performanceDataStartTime?.applyValue({ args0 -> args0 }))
            .performanceUtilizationPercentile(performanceUtilizationPercentile?.applyValue({ args0 -> args0 }))
            .savingsOption(
                savingsOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetLocation(targetLocation.applyValue({ args0 -> args0 }))
            .wacc(wacc?.applyValue({ args0 -> args0 }))
            .workloadDiscoverySource(
                workloadDiscoverySource?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AzureSettingsArgs].
 */
@PulumiTagMarker
public class AzureSettingsArgsBuilder internal constructor() {
    private var avsLaborCostPercentage: Output<Double>? = null

    private var businessCaseType: Output<Either<String, MigrationStrategy>>? = null

    private var comfortFactor: Output<Double>? = null

    private var currency: Output<Either<String, BusinessCaseCurrency>>? = null

    private var discountPercentage: Output<Double>? = null

    private var iaasLaborCostPercentage: Output<Double>? = null

    private var infrastructureGrowthRate: Output<Double>? = null

    private var networkCostPercentage: Output<Double>? = null

    private var paasLaborCostPercentage: Output<Double>? = null

    private var perYearMigrationCompletionPercentage: Output<Map<String, Double>>? = null

    private var performanceDataEndTime: Output<String>? = null

    private var performanceDataStartTime: Output<String>? = null

    private var performanceUtilizationPercentile: Output<Double>? = null

    private var savingsOption: Output<Either<String, SavingsOption>>? = null

    private var targetLocation: Output<String>? = null

    private var wacc: Output<Double>? = null

    private var workloadDiscoverySource: Output<Either<String, DiscoverySource>>? = null

    /**
     * @param value Gets Avs labour cost percentage.
     */
    @JvmName("vcaxihexdyhhvoxm")
    public suspend fun avsLaborCostPercentage(`value`: Output<Double>) {
        this.avsLaborCostPercentage = value
    }

    /**
     * @param value Migration Strategy.
     */
    @JvmName("wrwupiuschukmovn")
    public suspend fun businessCaseType(`value`: Output<Either<String, MigrationStrategy>>) {
        this.businessCaseType = value
    }

    /**
     * @param value Gets comfort factor.
     */
    @JvmName("gwgxfgqidobeitdy")
    public suspend fun comfortFactor(`value`: Output<Double>) {
        this.comfortFactor = value
    }

    /**
     * @param value Business case Currency.
     */
    @JvmName("ojutqrybicaiwmjl")
    public suspend fun currency(`value`: Output<Either<String, BusinessCaseCurrency>>) {
        this.currency = value
    }

    /**
     * @param value Gets azure Discount percentage.
     */
    @JvmName("nkfktopnuowmbfvf")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Gets IaaS labour cost percentage.
     */
    @JvmName("hbnvgatevpogrple")
    public suspend fun iaasLaborCostPercentage(`value`: Output<Double>) {
        this.iaasLaborCostPercentage = value
    }

    /**
     * @param value Gets infrastructure growth rate.
     */
    @JvmName("cfivpmjeweirluuv")
    public suspend fun infrastructureGrowthRate(`value`: Output<Double>) {
        this.infrastructureGrowthRate = value
    }

    /**
     * @param value Gets network cost percentage.
     */
    @JvmName("hjrkiobrtnkedngr")
    public suspend fun networkCostPercentage(`value`: Output<Double>) {
        this.networkCostPercentage = value
    }

    /**
     * @param value Gets PaaS labour cost percentage.
     */
    @JvmName("wgchaenxqncrjucf")
    public suspend fun paasLaborCostPercentage(`value`: Output<Double>) {
        this.paasLaborCostPercentage = value
    }

    /**
     * @param value Gets migration completion percentage per year.
     */
    @JvmName("lqhjgqxfqblybnvt")
    public suspend fun perYearMigrationCompletionPercentage(`value`: Output<Map<String, Double>>) {
        this.perYearMigrationCompletionPercentage = value
    }

    /**
     * @param value Gets end time to use for performance.
     */
    @JvmName("fchsdxdfdlsirulr")
    public suspend fun performanceDataEndTime(`value`: Output<String>) {
        this.performanceDataEndTime = value
    }

    /**
     * @param value Gets start time to use for performance.
     */
    @JvmName("bbumtfxlnwlovxnr")
    public suspend fun performanceDataStartTime(`value`: Output<String>) {
        this.performanceDataStartTime = value
    }

    /**
     * @param value Gets utilization percentile for performance.
     */
    @JvmName("qbksxruwdaltxkti")
    public suspend fun performanceUtilizationPercentile(`value`: Output<Double>) {
        this.performanceUtilizationPercentile = value
    }

    /**
     * @param value Gets the business case savings option type.
     */
    @JvmName("dpxgkjbceeghqyau")
    public suspend fun savingsOption(`value`: Output<Either<String, SavingsOption>>) {
        this.savingsOption = value
    }

    /**
     * @param value Gets or sets azure location.
     */
    @JvmName("dtprbfutbidqdxnm")
    public suspend fun targetLocation(`value`: Output<String>) {
        this.targetLocation = value
    }

    /**
     * @param value Gets wACC percentage.
     */
    @JvmName("dddestxijrsrlsax")
    public suspend fun wacc(`value`: Output<Double>) {
        this.wacc = value
    }

    /**
     * @param value Workload discovery source.
     */
    @JvmName("dwxwgrvtqlqdmwlc")
    public suspend fun workloadDiscoverySource(`value`: Output<Either<String, DiscoverySource>>) {
        this.workloadDiscoverySource = value
    }

    /**
     * @param value Gets Avs labour cost percentage.
     */
    @JvmName("qitlenrbmnfyrdek")
    public suspend fun avsLaborCostPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avsLaborCostPercentage = mapped
    }

    /**
     * @param value Migration Strategy.
     */
    @JvmName("qfxcbsukgtrvfesr")
    public suspend fun businessCaseType(`value`: Either<String, MigrationStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessCaseType = mapped
    }

    /**
     * @param value Migration Strategy.
     */
    @JvmName("wslvjtlexynjifln")
    public fun businessCaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MigrationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.businessCaseType = mapped
    }

    /**
     * @param value Migration Strategy.
     */
    @JvmName("vtuscghiatjuxjqh")
    public fun businessCaseType(`value`: MigrationStrategy) {
        val toBeMapped = Either.ofRight<String, MigrationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.businessCaseType = mapped
    }

    /**
     * @param value Gets comfort factor.
     */
    @JvmName("vansieoqxwdoolht")
    public suspend fun comfortFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comfortFactor = mapped
    }

    /**
     * @param value Business case Currency.
     */
    @JvmName("oisaxnblrnbrdeie")
    public suspend fun currency(`value`: Either<String, BusinessCaseCurrency>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Business case Currency.
     */
    @JvmName("ivgitfgfqjshhivs")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BusinessCaseCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Business case Currency.
     */
    @JvmName("yciwvapepdyhejoc")
    public fun currency(`value`: BusinessCaseCurrency) {
        val toBeMapped = Either.ofRight<String, BusinessCaseCurrency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Gets azure Discount percentage.
     */
    @JvmName("icjprqyqxgpgqfgq")
    public suspend fun discountPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Gets IaaS labour cost percentage.
     */
    @JvmName("vjxufmtdhmweliid")
    public suspend fun iaasLaborCostPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iaasLaborCostPercentage = mapped
    }

    /**
     * @param value Gets infrastructure growth rate.
     */
    @JvmName("rcfyffjimjbgjupb")
    public suspend fun infrastructureGrowthRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureGrowthRate = mapped
    }

    /**
     * @param value Gets network cost percentage.
     */
    @JvmName("nyhhegyoregsmprr")
    public suspend fun networkCostPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCostPercentage = mapped
    }

    /**
     * @param value Gets PaaS labour cost percentage.
     */
    @JvmName("taotlypsvigfljgx")
    public suspend fun paasLaborCostPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paasLaborCostPercentage = mapped
    }

    /**
     * @param value Gets migration completion percentage per year.
     */
    @JvmName("iqrnusyelkaslvjl")
    public suspend fun perYearMigrationCompletionPercentage(`value`: Map<String, Double>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perYearMigrationCompletionPercentage = mapped
    }

    /**
     * @param values Gets migration completion percentage per year.
     */
    @JvmName("ajuojppegsvnmtmk")
    public fun perYearMigrationCompletionPercentage(vararg values: Pair<String, Double>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.perYearMigrationCompletionPercentage = mapped
    }

    /**
     * @param value Gets end time to use for performance.
     */
    @JvmName("wjokbxyiniaxyubs")
    public suspend fun performanceDataEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceDataEndTime = mapped
    }

    /**
     * @param value Gets start time to use for performance.
     */
    @JvmName("ldihmxfslqlvcymh")
    public suspend fun performanceDataStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceDataStartTime = mapped
    }

    /**
     * @param value Gets utilization percentile for performance.
     */
    @JvmName("nmqkyufrkfxiwaru")
    public suspend fun performanceUtilizationPercentile(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceUtilizationPercentile = mapped
    }

    /**
     * @param value Gets the business case savings option type.
     */
    @JvmName("lbyumehsdprxapkj")
    public suspend fun savingsOption(`value`: Either<String, SavingsOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.savingsOption = mapped
    }

    /**
     * @param value Gets the business case savings option type.
     */
    @JvmName("cdrclolkftffswht")
    public fun savingsOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SavingsOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.savingsOption = mapped
    }

    /**
     * @param value Gets the business case savings option type.
     */
    @JvmName("dyciexgmsdxokhbc")
    public fun savingsOption(`value`: SavingsOption) {
        val toBeMapped = Either.ofRight<String, SavingsOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.savingsOption = mapped
    }

    /**
     * @param value Gets or sets azure location.
     */
    @JvmName("vqtcpolqgcewmunw")
    public suspend fun targetLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetLocation = mapped
    }

    /**
     * @param value Gets wACC percentage.
     */
    @JvmName("bwegsgqydawngejn")
    public suspend fun wacc(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wacc = mapped
    }

    /**
     * @param value Workload discovery source.
     */
    @JvmName("jewjxukxgmfrtfbq")
    public suspend fun workloadDiscoverySource(`value`: Either<String, DiscoverySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadDiscoverySource = mapped
    }

    /**
     * @param value Workload discovery source.
     */
    @JvmName("gstsksbqsovwulby")
    public fun workloadDiscoverySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiscoverySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadDiscoverySource = mapped
    }

    /**
     * @param value Workload discovery source.
     */
    @JvmName("tvpdllssmhhhmung")
    public fun workloadDiscoverySource(`value`: DiscoverySource) {
        val toBeMapped = Either.ofRight<String, DiscoverySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadDiscoverySource = mapped
    }

    internal fun build(): AzureSettingsArgs = AzureSettingsArgs(
        avsLaborCostPercentage = avsLaborCostPercentage,
        businessCaseType = businessCaseType,
        comfortFactor = comfortFactor,
        currency = currency ?: throw PulumiNullFieldException("currency"),
        discountPercentage = discountPercentage,
        iaasLaborCostPercentage = iaasLaborCostPercentage,
        infrastructureGrowthRate = infrastructureGrowthRate,
        networkCostPercentage = networkCostPercentage,
        paasLaborCostPercentage = paasLaborCostPercentage,
        perYearMigrationCompletionPercentage = perYearMigrationCompletionPercentage,
        performanceDataEndTime = performanceDataEndTime,
        performanceDataStartTime = performanceDataStartTime,
        performanceUtilizationPercentile = performanceUtilizationPercentile,
        savingsOption = savingsOption,
        targetLocation = targetLocation ?: throw PulumiNullFieldException("targetLocation"),
        wacc = wacc,
        workloadDiscoverySource = workloadDiscoverySource,
    )
}
