@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Compute settings.
 * @property hyperthreadCoreToMemoryRatio Hyperthread core to memory ratio.
 * @property price Compute Price.
 * @property rhelLinuxServerLicensing Linux Rhel Server licensing settings.
 * @property sqlServerLicensing SQL Server licensing settings.
 * @property suseLinuxServerLicensing Linux Suse Server licensing settings.
 * @property virtualizationSoftwareSettings Virtualization software settings.
 * @property windowsServerLicensing Windows Server licensing settings.
 */
public data class ComputeSettingsArgs(
    public val hyperthreadCoreToMemoryRatio: Output<Double>,
    public val price: Output<Double>,
    public val rhelLinuxServerLicensing: Output<LinuxServerLicensingSettingsArgs>,
    public val sqlServerLicensing: Output<List<SqlServerLicensingSettingsArgs>>,
    public val suseLinuxServerLicensing: Output<LinuxServerLicensingSettingsArgs>,
    public val virtualizationSoftwareSettings: Output<VirtualizationSoftwareSettingsArgs>,
    public val windowsServerLicensing: Output<WindowsServerLicensingSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.ComputeSettingsArgs.builder()
            .hyperthreadCoreToMemoryRatio(hyperthreadCoreToMemoryRatio.applyValue({ args0 -> args0 }))
            .price(price.applyValue({ args0 -> args0 }))
            .rhelLinuxServerLicensing(
                rhelLinuxServerLicensing.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqlServerLicensing(
                sqlServerLicensing.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .suseLinuxServerLicensing(
                suseLinuxServerLicensing.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualizationSoftwareSettings(
                virtualizationSoftwareSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .windowsServerLicensing(
                windowsServerLicensing.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ComputeSettingsArgs].
 */
@PulumiTagMarker
public class ComputeSettingsArgsBuilder internal constructor() {
    private var hyperthreadCoreToMemoryRatio: Output<Double>? = null

    private var price: Output<Double>? = null

    private var rhelLinuxServerLicensing: Output<LinuxServerLicensingSettingsArgs>? = null

    private var sqlServerLicensing: Output<List<SqlServerLicensingSettingsArgs>>? = null

    private var suseLinuxServerLicensing: Output<LinuxServerLicensingSettingsArgs>? = null

    private var virtualizationSoftwareSettings: Output<VirtualizationSoftwareSettingsArgs>? = null

    private var windowsServerLicensing: Output<WindowsServerLicensingSettingsArgs>? = null

    /**
     * @param value Hyperthread core to memory ratio.
     */
    @JvmName("dwgfcsrkbnlvxaxa")
    public suspend fun hyperthreadCoreToMemoryRatio(`value`: Output<Double>) {
        this.hyperthreadCoreToMemoryRatio = value
    }

    /**
     * @param value Compute Price.
     */
    @JvmName("jnrwxirgqwnetblm")
    public suspend fun price(`value`: Output<Double>) {
        this.price = value
    }

    /**
     * @param value Linux Rhel Server licensing settings.
     */
    @JvmName("pcpehnwtpawqrgqi")
    public suspend fun rhelLinuxServerLicensing(`value`: Output<LinuxServerLicensingSettingsArgs>) {
        this.rhelLinuxServerLicensing = value
    }

    /**
     * @param value SQL Server licensing settings.
     */
    @JvmName("ldhhetmnbtjwnrse")
    public suspend fun sqlServerLicensing(`value`: Output<List<SqlServerLicensingSettingsArgs>>) {
        this.sqlServerLicensing = value
    }

    @JvmName("wkxwtlbdajybjspn")
    public suspend fun sqlServerLicensing(vararg values: Output<SqlServerLicensingSettingsArgs>) {
        this.sqlServerLicensing = Output.all(values.asList())
    }

    /**
     * @param values SQL Server licensing settings.
     */
    @JvmName("gejhnchrmrhbvgtd")
    public suspend fun sqlServerLicensing(values: List<Output<SqlServerLicensingSettingsArgs>>) {
        this.sqlServerLicensing = Output.all(values)
    }

    /**
     * @param value Linux Suse Server licensing settings.
     */
    @JvmName("olfifsvvdttkjdkh")
    public suspend fun suseLinuxServerLicensing(`value`: Output<LinuxServerLicensingSettingsArgs>) {
        this.suseLinuxServerLicensing = value
    }

    /**
     * @param value Virtualization software settings.
     */
    @JvmName("ijxgxfgifsmrjqjl")
    public suspend fun virtualizationSoftwareSettings(`value`: Output<VirtualizationSoftwareSettingsArgs>) {
        this.virtualizationSoftwareSettings = value
    }

    /**
     * @param value Windows Server licensing settings.
     */
    @JvmName("ngikxfrontoqbhdc")
    public suspend fun windowsServerLicensing(`value`: Output<WindowsServerLicensingSettingsArgs>) {
        this.windowsServerLicensing = value
    }

    /**
     * @param value Hyperthread core to memory ratio.
     */
    @JvmName("bsesfrmtlmchluej")
    public suspend fun hyperthreadCoreToMemoryRatio(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperthreadCoreToMemoryRatio = mapped
    }

    /**
     * @param value Compute Price.
     */
    @JvmName("qomsgmdmpikibvxx")
    public suspend fun price(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.price = mapped
    }

    /**
     * @param value Linux Rhel Server licensing settings.
     */
    @JvmName("pygpibieqgigphbt")
    public suspend fun rhelLinuxServerLicensing(`value`: LinuxServerLicensingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rhelLinuxServerLicensing = mapped
    }

    /**
     * @param argument Linux Rhel Server licensing settings.
     */
    @JvmName("vnwvwyixejdhdkvv")
    public suspend fun rhelLinuxServerLicensing(argument: suspend LinuxServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxServerLicensingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rhelLinuxServerLicensing = mapped
    }

    /**
     * @param value SQL Server licensing settings.
     */
    @JvmName("ejjjjdukhhcbjrxn")
    public suspend fun sqlServerLicensing(`value`: List<SqlServerLicensingSettingsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicensing = mapped
    }

    /**
     * @param argument SQL Server licensing settings.
     */
    @JvmName("stbrorugcusmadme")
    public suspend fun sqlServerLicensing(argument: List<suspend SqlServerLicensingSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlServerLicensingSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlServerLicensing = mapped
    }

    /**
     * @param argument SQL Server licensing settings.
     */
    @JvmName("jjaffojfnsdxtfgm")
    public suspend fun sqlServerLicensing(vararg argument: suspend SqlServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SqlServerLicensingSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlServerLicensing = mapped
    }

    /**
     * @param argument SQL Server licensing settings.
     */
    @JvmName("qoeyormnewupvdda")
    public suspend fun sqlServerLicensing(argument: suspend SqlServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SqlServerLicensingSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sqlServerLicensing = mapped
    }

    /**
     * @param values SQL Server licensing settings.
     */
    @JvmName("jdeprktcvyibmovh")
    public suspend fun sqlServerLicensing(vararg values: SqlServerLicensingSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicensing = mapped
    }

    /**
     * @param value Linux Suse Server licensing settings.
     */
    @JvmName("vlsdneffdrgryetl")
    public suspend fun suseLinuxServerLicensing(`value`: LinuxServerLicensingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suseLinuxServerLicensing = mapped
    }

    /**
     * @param argument Linux Suse Server licensing settings.
     */
    @JvmName("folgolwlcuxxxknu")
    public suspend fun suseLinuxServerLicensing(argument: suspend LinuxServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxServerLicensingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.suseLinuxServerLicensing = mapped
    }

    /**
     * @param value Virtualization software settings.
     */
    @JvmName("idflvequihavbdvd")
    public suspend fun virtualizationSoftwareSettings(`value`: VirtualizationSoftwareSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualizationSoftwareSettings = mapped
    }

    /**
     * @param argument Virtualization software settings.
     */
    @JvmName("pkvsnxkarixekqbi")
    public suspend fun virtualizationSoftwareSettings(argument: suspend VirtualizationSoftwareSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualizationSoftwareSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualizationSoftwareSettings = mapped
    }

    /**
     * @param value Windows Server licensing settings.
     */
    @JvmName("jpdptbedittbpcgg")
    public suspend fun windowsServerLicensing(`value`: WindowsServerLicensingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsServerLicensing = mapped
    }

    /**
     * @param argument Windows Server licensing settings.
     */
    @JvmName("xkhpitxgfqcyeqxs")
    public suspend fun windowsServerLicensing(argument: suspend WindowsServerLicensingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsServerLicensingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsServerLicensing = mapped
    }

    internal fun build(): ComputeSettingsArgs = ComputeSettingsArgs(
        hyperthreadCoreToMemoryRatio = hyperthreadCoreToMemoryRatio ?: throw
            PulumiNullFieldException("hyperthreadCoreToMemoryRatio"),
        price = price ?: throw PulumiNullFieldException("price"),
        rhelLinuxServerLicensing = rhelLinuxServerLicensing ?: throw
            PulumiNullFieldException("rhelLinuxServerLicensing"),
        sqlServerLicensing = sqlServerLicensing ?: throw PulumiNullFieldException("sqlServerLicensing"),
        suseLinuxServerLicensing = suseLinuxServerLicensing ?: throw
            PulumiNullFieldException("suseLinuxServerLicensing"),
        virtualizationSoftwareSettings = virtualizationSoftwareSettings ?: throw
            PulumiNullFieldException("virtualizationSoftwareSettings"),
        windowsServerLicensing = windowsServerLicensing ?: throw
            PulumiNullFieldException("windowsServerLicensing"),
    )
}
