@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetAksAssessmentOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentName AKS Assessment Name.
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAksAssessmentOperationPlainArgs(
    public val assessmentName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetAksAssessmentOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetAksAssessmentOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetAksAssessmentOperationPlainArgs.builder()
            .assessmentName(assessmentName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAksAssessmentOperationPlainArgs].
 */
@PulumiTagMarker
public class GetAksAssessmentOperationPlainArgsBuilder internal constructor() {
    private var assessmentName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value AKS Assessment Name.
     */
    @JvmName("thnleqatqmgrljvx")
    public suspend fun assessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("pdkdhdwocowfbshm")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("amhhrbfsyqvytbhl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAksAssessmentOperationPlainArgs = GetAksAssessmentOperationPlainArgs(
        assessmentName = assessmentName ?: throw PulumiNullFieldException("assessmentName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
