@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetGroupsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupName Group ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGroupsOperationPlainArgs(
    public val groupName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetGroupsOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetGroupsOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetGroupsOperationPlainArgs.builder()
            .groupName(groupName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetGroupsOperationPlainArgsBuilder internal constructor() {
    private var groupName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Group ARM name
     */
    @JvmName("vmkjodsaqylmhses")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("fgxyylenfysksydr")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uyjbxrcibhtewxqo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGroupsOperationPlainArgs = GetGroupsOperationPlainArgs(
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
