@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetHypervCollectorsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hypervCollectorName Hyper-V collector ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetHypervCollectorsOperationPlainArgs(
    public val hypervCollectorName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetHypervCollectorsOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetHypervCollectorsOperationPlainArgs = com.pulumi.azurenative.migrate.inputs.GetHypervCollectorsOperationPlainArgs.builder()
        .hypervCollectorName(hypervCollectorName.let({ args0 -> args0 }))
        .projectName(projectName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHypervCollectorsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetHypervCollectorsOperationPlainArgsBuilder internal constructor() {
    private var hypervCollectorName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Hyper-V collector ARM name
     */
    @JvmName("ttbaumfbbeldswll")
    public suspend fun hypervCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hypervCollectorName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("hcbubqgkwsgcxwni")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lhcvcoxosxtmhplh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHypervCollectorsOperationPlainArgs =
        GetHypervCollectorsOperationPlainArgs(
            hypervCollectorName = hypervCollectorName ?: throw PulumiNullFieldException("hypervCollectorName"),
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
