@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName Private endpoint connection ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionOperationPlainArgs(
    public val privateEndpointConnectionName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionOperationPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionOperationPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionOperationPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Private endpoint connection ARM name
     */
    @JvmName("gtgdfnjicwnppyxy")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("uihwwmhinposwmow")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lpquceyjjlvchkrb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionOperationPlainArgs =
        GetPrivateEndpointConnectionOperationPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
