@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetWebAppCollectorOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectorName Web app collector ARM name.
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWebAppCollectorOperationPlainArgs(
    public val collectorName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetWebAppCollectorOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetWebAppCollectorOperationPlainArgs = com.pulumi.azurenative.migrate.inputs.GetWebAppCollectorOperationPlainArgs.builder()
        .collectorName(collectorName.let({ args0 -> args0 }))
        .projectName(projectName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppCollectorOperationPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppCollectorOperationPlainArgsBuilder internal constructor() {
    private var collectorName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Web app collector ARM name.
     */
    @JvmName("ekduvbwkfjvhxkim")
    public suspend fun collectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collectorName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("okgnihbmkcobqypk")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("heituajignevaeum")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppCollectorOperationPlainArgs = GetWebAppCollectorOperationPlainArgs(
        collectorName = collectorName ?: throw PulumiNullFieldException("collectorName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
