@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.HypervVirtualizationManagementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * HyperV Virtualization Management Settings.
 * @property licenseAndSupportList Licence and support list.
 * @property numberOfPhysicalCoresPerLicense Number of physical cores per licence.
 * @property softwareAssuranceCost Software Assurance Cost.
 */
public data class HypervVirtualizationManagementSettingsArgs(
    public val licenseAndSupportList: Output<List<HypervLicenseArgs>>,
    public val numberOfPhysicalCoresPerLicense: Output<Int>,
    public val softwareAssuranceCost: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.HypervVirtualizationManagementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.HypervVirtualizationManagementSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.HypervVirtualizationManagementSettingsArgs.builder()
            .licenseAndSupportList(
                licenseAndSupportList.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .numberOfPhysicalCoresPerLicense(numberOfPhysicalCoresPerLicense.applyValue({ args0 -> args0 }))
            .softwareAssuranceCost(softwareAssuranceCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HypervVirtualizationManagementSettingsArgs].
 */
@PulumiTagMarker
public class HypervVirtualizationManagementSettingsArgsBuilder internal constructor() {
    private var licenseAndSupportList: Output<List<HypervLicenseArgs>>? = null

    private var numberOfPhysicalCoresPerLicense: Output<Int>? = null

    private var softwareAssuranceCost: Output<Double>? = null

    /**
     * @param value Licence and support list.
     */
    @JvmName("nddpgeptbcimsdyq")
    public suspend fun licenseAndSupportList(`value`: Output<List<HypervLicenseArgs>>) {
        this.licenseAndSupportList = value
    }

    @JvmName("odqtpixlonbfvpsg")
    public suspend fun licenseAndSupportList(vararg values: Output<HypervLicenseArgs>) {
        this.licenseAndSupportList = Output.all(values.asList())
    }

    /**
     * @param values Licence and support list.
     */
    @JvmName("leguqgkgghrwwkwr")
    public suspend fun licenseAndSupportList(values: List<Output<HypervLicenseArgs>>) {
        this.licenseAndSupportList = Output.all(values)
    }

    /**
     * @param value Number of physical cores per licence.
     */
    @JvmName("wjdhhguyjmqybeti")
    public suspend fun numberOfPhysicalCoresPerLicense(`value`: Output<Int>) {
        this.numberOfPhysicalCoresPerLicense = value
    }

    /**
     * @param value Software Assurance Cost.
     */
    @JvmName("slfkovqujumexewi")
    public suspend fun softwareAssuranceCost(`value`: Output<Double>) {
        this.softwareAssuranceCost = value
    }

    /**
     * @param value Licence and support list.
     */
    @JvmName("trqrthcishvvpedu")
    public suspend fun licenseAndSupportList(`value`: List<HypervLicenseArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("ryclvikuxwypuxiu")
    public suspend fun licenseAndSupportList(argument: List<suspend HypervLicenseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HypervLicenseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("ijbdvcwnavnxtxig")
    public suspend fun licenseAndSupportList(vararg argument: suspend HypervLicenseArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HypervLicenseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("ahteedkaeslkfivm")
    public suspend fun licenseAndSupportList(argument: suspend HypervLicenseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HypervLicenseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param values Licence and support list.
     */
    @JvmName("kqkroioxojkhwhgf")
    public suspend fun licenseAndSupportList(vararg values: HypervLicenseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseAndSupportList = mapped
    }

    /**
     * @param value Number of physical cores per licence.
     */
    @JvmName("uqxhenecxarjgqoc")
    public suspend fun numberOfPhysicalCoresPerLicense(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfPhysicalCoresPerLicense = mapped
    }

    /**
     * @param value Software Assurance Cost.
     */
    @JvmName("srrwafaphqitasep")
    public suspend fun softwareAssuranceCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceCost = mapped
    }

    internal fun build(): HypervVirtualizationManagementSettingsArgs =
        HypervVirtualizationManagementSettingsArgs(
            licenseAndSupportList = licenseAndSupportList ?: throw
                PulumiNullFieldException("licenseAndSupportList"),
            numberOfPhysicalCoresPerLicense = numberOfPhysicalCoresPerLicense ?: throw
                PulumiNullFieldException("numberOfPhysicalCoresPerLicense"),
            softwareAssuranceCost = softwareAssuranceCost ?: throw
                PulumiNullFieldException("softwareAssuranceCost"),
        )
}
