@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IISWebServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IISWeb server.
 * @property displayName Gets or sets the display name.
 * @property ipAddresses Gets or sets list of ip addresses.
 * @property machines Gets or sets the list of machines.
 * @property operatingSystemDetails
 * @property rootConfigurationLocation Gets or sets the server root configuration location.
 * @property runAsAccountId Gets or sets the run as account id.
 * @property serverFqdn Gets or sets the server FQDN.
 * @property serverId Gets or sets the web server id.
 * @property serverName Gets or sets the web server name.
 * @property version Gets or sets the server version.
 * @property webApplications Gets or sets the list of web applications.
 */
public data class IISWebServerArgs(
    public val displayName: Output<String>? = null,
    public val ipAddresses: Output<List<String>>? = null,
    public val machines: Output<List<String>>? = null,
    public val operatingSystemDetails: Output<OperatingSystemDetailsArgs>? = null,
    public val rootConfigurationLocation: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
    public val serverFqdn: Output<String>? = null,
    public val serverId: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val webApplications: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IISWebServerArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IISWebServerArgs =
        com.pulumi.azurenative.migrate.inputs.IISWebServerArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .machines(machines?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .operatingSystemDetails(
                operatingSystemDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rootConfigurationLocation(rootConfigurationLocation?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .serverFqdn(serverFqdn?.applyValue({ args0 -> args0 }))
            .serverId(serverId?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .webApplications(webApplications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IISWebServerArgs].
 */
@PulumiTagMarker
public class IISWebServerArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var ipAddresses: Output<List<String>>? = null

    private var machines: Output<List<String>>? = null

    private var operatingSystemDetails: Output<OperatingSystemDetailsArgs>? = null

    private var rootConfigurationLocation: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var serverFqdn: Output<String>? = null

    private var serverId: Output<String>? = null

    private var serverName: Output<String>? = null

    private var version: Output<String>? = null

    private var webApplications: Output<List<String>>? = null

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("xfkyerchjbgxeirw")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Gets or sets list of ip addresses.
     */
    @JvmName("illxbvhuhcaqmsiq")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("xyljqefdbnopkcnr")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets list of ip addresses.
     */
    @JvmName("akopivcvcbqtglyb")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of machines.
     */
    @JvmName("limrfmqmbrvekgaj")
    public suspend fun machines(`value`: Output<List<String>>) {
        this.machines = value
    }

    @JvmName("bcgqtrleivpaoiny")
    public suspend fun machines(vararg values: Output<String>) {
        this.machines = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of machines.
     */
    @JvmName("ohvboarpyckgoilk")
    public suspend fun machines(values: List<Output<String>>) {
        this.machines = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("buwwpeytnjlbsnol")
    public suspend fun operatingSystemDetails(`value`: Output<OperatingSystemDetailsArgs>) {
        this.operatingSystemDetails = value
    }

    /**
     * @param value Gets or sets the server root configuration location.
     */
    @JvmName("gcqnofydiawgnund")
    public suspend fun rootConfigurationLocation(`value`: Output<String>) {
        this.rootConfigurationLocation = value
    }

    /**
     * @param value Gets or sets the run as account id.
     */
    @JvmName("inqaliaknqcxmunl")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value Gets or sets the server FQDN.
     */
    @JvmName("ihftcimvwjftqfxx")
    public suspend fun serverFqdn(`value`: Output<String>) {
        this.serverFqdn = value
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("riumdiygedxgagoc")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("xlrhixssdvmqwdye")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Gets or sets the server version.
     */
    @JvmName("bdyiypwbnxfaouam")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Gets or sets the list of web applications.
     */
    @JvmName("amimtwkyhggxloeh")
    public suspend fun webApplications(`value`: Output<List<String>>) {
        this.webApplications = value
    }

    @JvmName("ndimxysrdhdpqixv")
    public suspend fun webApplications(vararg values: Output<String>) {
        this.webApplications = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of web applications.
     */
    @JvmName("xyuryjlostwsfwvu")
    public suspend fun webApplications(values: List<Output<String>>) {
        this.webApplications = Output.all(values)
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("avoomavbsoladmcj")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Gets or sets list of ip addresses.
     */
    @JvmName("xnbynkpsbnejpfxi")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values Gets or sets list of ip addresses.
     */
    @JvmName("yupltitnesycbymq")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value Gets or sets the list of machines.
     */
    @JvmName("vidbccryocxfogbg")
    public suspend fun machines(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machines = mapped
    }

    /**
     * @param values Gets or sets the list of machines.
     */
    @JvmName("wnfncchtxfeernpm")
    public suspend fun machines(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machines = mapped
    }

    /**
     * @param value
     */
    @JvmName("apewgeglsyhovrdo")
    public suspend fun operatingSystemDetails(`value`: OperatingSystemDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystemDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qpehbmapasnxkhfx")
    public suspend fun operatingSystemDetails(argument: suspend OperatingSystemDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = OperatingSystemDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.operatingSystemDetails = mapped
    }

    /**
     * @param value Gets or sets the server root configuration location.
     */
    @JvmName("yhnkepqwxellclym")
    public suspend fun rootConfigurationLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootConfigurationLocation = mapped
    }

    /**
     * @param value Gets or sets the run as account id.
     */
    @JvmName("wappxrxardqppggr")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value Gets or sets the server FQDN.
     */
    @JvmName("obftcqdxhoamjifn")
    public suspend fun serverFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverFqdn = mapped
    }

    /**
     * @param value Gets or sets the web server id.
     */
    @JvmName("gjqtjdgjwosqkfbs")
    public suspend fun serverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value Gets or sets the web server name.
     */
    @JvmName("xycaauxojdacnqpk")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Gets or sets the server version.
     */
    @JvmName("xdtcbcaduynfnxwr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Gets or sets the list of web applications.
     */
    @JvmName("kilickhiwgyfthfw")
    public suspend fun webApplications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webApplications = mapped
    }

    /**
     * @param values Gets or sets the list of web applications.
     */
    @JvmName("iovesijimkkgbgyh")
    public suspend fun webApplications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webApplications = mapped
    }

    internal fun build(): IISWebServerArgs = IISWebServerArgs(
        displayName = displayName,
        ipAddresses = ipAddresses,
        machines = machines,
        operatingSystemDetails = operatingSystemDetails,
        rootConfigurationLocation = rootConfigurationLocation,
        runAsAccountId = runAsAccountId,
        serverFqdn = serverFqdn,
        serverId = serverId,
        serverName = serverName,
        version = version,
        webApplications = webApplications,
    )
}
