@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IISWorkloadInstanceModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IIS workload instance model custom properties.
 * @property containerName Gets or sets the container Id.
 * @property fileshareName Gets or sets the fileshare name.
 * @property iisWebApplication IISWeb application.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'IISWorkloadInstanceModelCustomProperties'.
 * @property webAppArmId Gets or sets the Web application ARM id.
 * @property webAppSiteName Gets or sets the Web application site name.
 */
public data class IISWorkloadInstanceModelCustomPropertiesArgs(
    public val containerName: Output<String>? = null,
    public val fileshareName: Output<String>? = null,
    public val iisWebApplication: Output<IISWebApplicationArgs>? = null,
    public val instanceType: Output<String>,
    public val webAppArmId: Output<String>? = null,
    public val webAppSiteName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IISWorkloadInstanceModelCustomPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IISWorkloadInstanceModelCustomPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.IISWorkloadInstanceModelCustomPropertiesArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .fileshareName(fileshareName?.applyValue({ args0 -> args0 }))
            .iisWebApplication(iisWebApplication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .webAppArmId(webAppArmId?.applyValue({ args0 -> args0 }))
            .webAppSiteName(webAppSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IISWorkloadInstanceModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class IISWorkloadInstanceModelCustomPropertiesArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var fileshareName: Output<String>? = null

    private var iisWebApplication: Output<IISWebApplicationArgs>? = null

    private var instanceType: Output<String>? = null

    private var webAppArmId: Output<String>? = null

    private var webAppSiteName: Output<String>? = null

    /**
     * @param value Gets or sets the container Id.
     */
    @JvmName("eerlnaocbawgqvbw")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Gets or sets the fileshare name.
     */
    @JvmName("gnhafhxslmsaensc")
    public suspend fun fileshareName(`value`: Output<String>) {
        this.fileshareName = value
    }

    /**
     * @param value IISWeb application.
     */
    @JvmName("ymmvcknoiqpunjjg")
    public suspend fun iisWebApplication(`value`: Output<IISWebApplicationArgs>) {
        this.iisWebApplication = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'IISWorkloadInstanceModelCustomProperties'.
     */
    @JvmName("xcnokuoibnutbhcu")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the Web application ARM id.
     */
    @JvmName("bebemqfbvogdotwm")
    public suspend fun webAppArmId(`value`: Output<String>) {
        this.webAppArmId = value
    }

    /**
     * @param value Gets or sets the Web application site name.
     */
    @JvmName("qovvxjynsncbojkp")
    public suspend fun webAppSiteName(`value`: Output<String>) {
        this.webAppSiteName = value
    }

    /**
     * @param value Gets or sets the container Id.
     */
    @JvmName("gwthygthhxrooxce")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Gets or sets the fileshare name.
     */
    @JvmName("aypsfaqlperwlwtj")
    public suspend fun fileshareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileshareName = mapped
    }

    /**
     * @param value IISWeb application.
     */
    @JvmName("tdnapycyerkqbrtw")
    public suspend fun iisWebApplication(`value`: IISWebApplicationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iisWebApplication = mapped
    }

    /**
     * @param argument IISWeb application.
     */
    @JvmName("qxxnsqqgjwjkxdca")
    public suspend fun iisWebApplication(argument: suspend IISWebApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = IISWebApplicationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.iisWebApplication = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'IISWorkloadInstanceModelCustomProperties'.
     */
    @JvmName("thddqpxjeuldgpel")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the Web application ARM id.
     */
    @JvmName("uyijtatekxnqsugh")
    public suspend fun webAppArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAppArmId = mapped
    }

    /**
     * @param value Gets or sets the Web application site name.
     */
    @JvmName("idgjenaeimidyjvt")
    public suspend fun webAppSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAppSiteName = mapped
    }

    internal fun build(): IISWorkloadInstanceModelCustomPropertiesArgs =
        IISWorkloadInstanceModelCustomPropertiesArgs(
            containerName = containerName,
            fileshareName = fileshareName,
            iisWebApplication = iisWebApplication,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            webAppArmId = webAppArmId,
            webAppSiteName = webAppSiteName,
        )
}
