@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IdentityArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the MSI properties of the Move Collection.
 * @property principalId Gets or sets the principal id.
 * @property tenantId Gets or sets the tenant id.
 * @property type The type of identity used for the resource mover service.
 */
public data class IdentityArgs(
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<Either<String, ResourceIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IdentityArgs =
        com.pulumi.azurenative.migrate.inputs.IdentityArgs.builder()
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<Either<String, ResourceIdentityType>>? = null

    /**
     * @param value Gets or sets the principal id.
     */
    @JvmName("jlrvjlbxgwnlypkl")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Gets or sets the tenant id.
     */
    @JvmName("svjkemuvylaskmjy")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The type of identity used for the resource mover service.
     */
    @JvmName("nknquqibvqfcuihh")
    public suspend fun type(`value`: Output<Either<String, ResourceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the principal id.
     */
    @JvmName("ubjaulgglsebcxei")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Gets or sets the tenant id.
     */
    @JvmName("wgvfhxhkektqqskr")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The type of identity used for the resource mover service.
     */
    @JvmName("bkkxkehlmrkyieqi")
    public suspend fun type(`value`: Either<String, ResourceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the resource mover service.
     */
    @JvmName("ywctobcbgvmnlyvc")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the resource mover service.
     */
    @JvmName("etqahxufsatvpcpq")
    public fun type(`value`: ResourceIdentityType) {
        val toBeMapped = Either.ofRight<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        principalId = principalId,
        tenantId = tenantId,
        type = type,
    )
}
