@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.LaborSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Labour settings.
 * @property hourlyAdminCost Hourly administrator cost.
 * @property physicalServersPerAdmin Physical servers per administrator.
 * @property virtualMachinesPerAdmin Virtual machines per administrator.
 */
public data class LaborSettingsArgs(
    public val hourlyAdminCost: Output<Double>,
    public val physicalServersPerAdmin: Output<Int>,
    public val virtualMachinesPerAdmin: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.LaborSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.LaborSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.LaborSettingsArgs.builder()
            .hourlyAdminCost(hourlyAdminCost.applyValue({ args0 -> args0 }))
            .physicalServersPerAdmin(physicalServersPerAdmin.applyValue({ args0 -> args0 }))
            .virtualMachinesPerAdmin(virtualMachinesPerAdmin.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaborSettingsArgs].
 */
@PulumiTagMarker
public class LaborSettingsArgsBuilder internal constructor() {
    private var hourlyAdminCost: Output<Double>? = null

    private var physicalServersPerAdmin: Output<Int>? = null

    private var virtualMachinesPerAdmin: Output<Int>? = null

    /**
     * @param value Hourly administrator cost.
     */
    @JvmName("qpakuqluploqwrdg")
    public suspend fun hourlyAdminCost(`value`: Output<Double>) {
        this.hourlyAdminCost = value
    }

    /**
     * @param value Physical servers per administrator.
     */
    @JvmName("vhckcbqqfdjrgpkq")
    public suspend fun physicalServersPerAdmin(`value`: Output<Int>) {
        this.physicalServersPerAdmin = value
    }

    /**
     * @param value Virtual machines per administrator.
     */
    @JvmName("qmikbhmxsybwokjc")
    public suspend fun virtualMachinesPerAdmin(`value`: Output<Int>) {
        this.virtualMachinesPerAdmin = value
    }

    /**
     * @param value Hourly administrator cost.
     */
    @JvmName("krkxnrctbouawyin")
    public suspend fun hourlyAdminCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hourlyAdminCost = mapped
    }

    /**
     * @param value Physical servers per administrator.
     */
    @JvmName("tlcbrlyyluiatdey")
    public suspend fun physicalServersPerAdmin(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.physicalServersPerAdmin = mapped
    }

    /**
     * @param value Virtual machines per administrator.
     */
    @JvmName("ysryqsvdhnfdgfqd")
    public suspend fun virtualMachinesPerAdmin(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachinesPerAdmin = mapped
    }

    internal fun build(): LaborSettingsArgs = LaborSettingsArgs(
        hourlyAdminCost = hourlyAdminCost ?: throw PulumiNullFieldException("hourlyAdminCost"),
        physicalServersPerAdmin = physicalServersPerAdmin ?: throw
            PulumiNullFieldException("physicalServersPerAdmin"),
        virtualMachinesPerAdmin = virtualMachinesPerAdmin ?: throw
            PulumiNullFieldException("virtualMachinesPerAdmin"),
    )
}
