@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.LinuxServerLicensingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Linux Server licensing settings.
 * @property licenseCost Licence Cost.
 */
public data class LinuxServerLicensingSettingsArgs(
    public val licenseCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.LinuxServerLicensingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.LinuxServerLicensingSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.LinuxServerLicensingSettingsArgs.builder()
            .licenseCost(licenseCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinuxServerLicensingSettingsArgs].
 */
@PulumiTagMarker
public class LinuxServerLicensingSettingsArgsBuilder internal constructor() {
    private var licenseCost: Output<Double>? = null

    /**
     * @param value Licence Cost.
     */
    @JvmName("yqukjolgghmkyslf")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value Licence Cost.
     */
    @JvmName("ovymoedorrhdugvy")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    internal fun build(): LinuxServerLicensingSettingsArgs = LinuxServerLicensingSettingsArgs(
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
    )
}
