@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.NetworkSecurityGroupResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the NSG resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/networkSecurityGroups'.
 * @property securityRules Gets or sets Security rules of network security group.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class NetworkSecurityGroupResourceSettingsArgs(
    public val resourceType: Output<String>,
    public val securityRules: Output<List<NsgSecurityRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.NetworkSecurityGroupResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.NetworkSecurityGroupResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.NetworkSecurityGroupResourceSettingsArgs.builder()
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .securityRules(
                securityRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkSecurityGroupResourceSettingsArgs].
 */
@PulumiTagMarker
public class NetworkSecurityGroupResourceSettingsArgsBuilder internal constructor() {
    private var resourceType: Output<String>? = null

    private var securityRules: Output<List<NsgSecurityRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/networkSecurityGroups'.
     */
    @JvmName("mevtqpynecjsxakj")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets Security rules of network security group.
     */
    @JvmName("obrucoqkouelbbre")
    public suspend fun securityRules(`value`: Output<List<NsgSecurityRuleArgs>>) {
        this.securityRules = value
    }

    @JvmName("uvnvtfvmlpkbwoss")
    public suspend fun securityRules(vararg values: Output<NsgSecurityRuleArgs>) {
        this.securityRules = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets Security rules of network security group.
     */
    @JvmName("dgsnlqhpthdxbkyk")
    public suspend fun securityRules(values: List<Output<NsgSecurityRuleArgs>>) {
        this.securityRules = Output.all(values)
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("svebdxatuqnkpktm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("mgyakmohsyjrjybt")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("qhqoytaovuhavfke")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/networkSecurityGroups'.
     */
    @JvmName("ucatkwddiaulcwxx")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets Security rules of network security group.
     */
    @JvmName("ujombefgyvetuyhw")
    public suspend fun securityRules(`value`: List<NsgSecurityRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityRules = mapped
    }

    /**
     * @param argument Gets or sets Security rules of network security group.
     */
    @JvmName("ojlbwwcfupueoctk")
    public suspend fun securityRules(argument: List<suspend NsgSecurityRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NsgSecurityRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param argument Gets or sets Security rules of network security group.
     */
    @JvmName("sjkhwgdrtvqtdain")
    public suspend fun securityRules(vararg argument: suspend NsgSecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NsgSecurityRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param argument Gets or sets Security rules of network security group.
     */
    @JvmName("xakdthyhlwhexadl")
    public suspend fun securityRules(argument: suspend NsgSecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NsgSecurityRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param values Gets or sets Security rules of network security group.
     */
    @JvmName("jstbcxkgargclvhe")
    public suspend fun securityRules(vararg values: NsgSecurityRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityRules = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("bvsiivrfmswkglbm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("pjihmfwekjhisqbu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("ajhlsdbcgjxipcpy")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("scgdoprddmwxrdoo")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    internal fun build(): NetworkSecurityGroupResourceSettingsArgs =
        NetworkSecurityGroupResourceSettingsArgs(
            resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
            securityRules = securityRules,
            tags = tags,
            targetResourceGroupName = targetResourceGroupName,
            targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        )
}
